/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Aggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static Resource resolveResourceRef(String resourceRef) {
        DeploymentDescriptor deplDescriptor = Aggregator.getDd1();
        for (Resource resource : deplDescriptor.getResources()) {
            if (resource.getResourceID().equalsIgnoreCase(resourceRef)) {
                return resource;
            }
            Resource retVal = Util.checkHostedResources(resourceRef, resource);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    private static Resource checkHostedResources(String resourceRef, Resource hostingResource) {
        Iterator hostedResourcesIter = hostingResource.getHostedResources().iterator();
        Resource foundResource = null;
        while (hostedResourcesIter.hasNext()) {
            Resource resource = (Resource)hostedResourcesIter.next();
            if (resource.getResourceID().equalsIgnoreCase(resourceRef)) {
                return resource;
            }
            foundResource = Util.checkHostedResources(resourceRef, resource);
        }
        return foundResource;
    }

    public static void updateContentRefs(String oldId, String newId) {
        Collection<DeploymentDescriptor> deploymentDescriptors = Aggregator.getAllDeploymentDescriptors();
        for (DeploymentDescriptor deplDescriptor : deploymentDescriptors) {
            Artifact uninstallArtifact;
            Artifact undoArtifact;
            Artifact updateArtifact;
            ConfigurationUnit configUnit;
            Artifact configArtifact;
            ContentUnit contentUnit = deplDescriptor.getContentUnit();
            if (contentUnit instanceof ConfigurationUnit && (configArtifact = (configUnit = (ConfigurationUnit)contentUnit).getConfigurationArtifact()) != null && !configArtifact.getContentReference().equals("") && configArtifact.getContentReference().equals(oldId)) {
                configArtifact.setContentReference(newId);
                Util.updateAdditionalContentTypes(oldId, newId, configArtifact.getAdditionalContents());
            }
            if (!(contentUnit instanceof InstallableUnit)) continue;
            InstallableUnit installableUnit = (InstallableUnit)contentUnit;
            Artifact installArtifact = installableUnit.getInstallArtifact();
            if (installArtifact != null && installArtifact.getContentReference().equals("") && installArtifact.getContentReference().equals(oldId)) {
                installArtifact.setContentReference(newId);
                Util.updateAdditionalContentTypes(oldId, newId, installArtifact.getAdditionalContents());
            }
            if ((updateArtifact = installableUnit.getUpdateArtifact()) != null && updateArtifact.getContentReference().equals("") && updateArtifact.getContentReference().equals(oldId)) {
                updateArtifact.setContentReference(newId);
                Util.updateAdditionalContentTypes(oldId, newId, updateArtifact.getAdditionalContents());
            }
            if ((undoArtifact = installableUnit.getUndoArtifact()) != null && undoArtifact.getContentReference().equals("") && undoArtifact.getContentReference().equals(oldId)) {
                undoArtifact.setContentReference(newId);
                Util.updateAdditionalContentTypes(oldId, newId, undoArtifact.getAdditionalContents());
            }
            if ((uninstallArtifact = installableUnit.getUninstallArtifact()) == null || !uninstallArtifact.getContentReference().equals("") || !uninstallArtifact.getContentReference().equals(oldId)) continue;
            uninstallArtifact.setContentReference(newId);
            Util.updateAdditionalContentTypes(oldId, newId, uninstallArtifact.getAdditionalContents());
        }
    }

    private static void updateAdditionalContentTypes(String oldId, String newId, Collection<AdditionalContent> additionalContent) {
        for (AdditionalContent content : additionalContent) {
            if (content.getContentReference().equals("") || !content.getContentReference().equals(oldId)) continue;
            content.setContentReference(newId);
        }
    }

    public static PackageContent resolveContentRef(String contentRef) {
        Collection<PackageDescriptor> pkgDescriptors = Aggregator.getAllPackageDescriptors();
        for (PackageDescriptor pkgDescriptor : pkgDescriptors) {
            for (PackageContent packageContent : pkgDescriptor.getPackageContents()) {
                if (!packageContent.getContentID().equals(contentRef)) continue;
                return packageContent;
            }
        }
        return null;
    }
}

