/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResourceMapImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.RelationshipImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultingResourceMapImpl
extends ResourceMapImpl
implements ResultingResourceMap {
    private static final String RESULTING_RESOURCE_MAP_TYPE = "sdd-dd:ResultingResourceMapType";
    private static final String RESULTING_PROPERTY_TYPE = "sdd-dd:ResultingPropertyType";

    public ResultingResourceMapImpl(Element rrmdo, SPISessionImpl session) {
        super(rrmdo, session, RESULTING_RESOURCE_MAP_TYPE);
    }

    @Override
    public Collection<String> getFixNames() {
        ArrayList<String> fixNames = new ArrayList<String>();
        Collection<Element> fixNameElements = this.getChildren("FixName");
        for (Element fixName : fixNameElements) {
            fixNames.add(fixName.getTextContent());
        }
        return fixNames;
    }

    @Override
    public String getName() {
        if (this.isSetElement("Name")) {
            Element name = this.getChild("Name");
            return name.getTextContent();
        }
        return null;
    }

    @Override
    public Properties getProperties() {
        Collection<Element> propertyElements = this.getChildren("Property");
        Properties properties = new Properties();
        for (Element propertyElement : propertyElements) {
            String propertyName = this.session.getChild(propertyElement, "PropertyName").getTextContent();
            String value = this.session.getChild(propertyElement, "Value").getTextContent();
            properties.put(propertyName, value);
        }
        return properties;
    }

    @Override
    public String getVersion() {
        if (this.isSetElement("Version")) {
            Element name = this.getChild("Version");
            return name.getTextContent();
        }
        return null;
    }

    @Override
    public void setFixNames(Collection<String> names) {
        this.removeContent(this.getChildren("FixName", false));
        ArrayList<Element> fixNameElements = new ArrayList<Element>();
        for (String fixName : names) {
            Element fixNameElement = this.session.createDeploymentElement("FixName");
            fixNameElement.setTextContent(fixName);
            fixNameElements.add(fixNameElement);
        }
        this.addContent(fixNameElements);
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.unSetElement("Name");
        } else {
            Element nameElement = this.session.createDeploymentElement("Name");
            nameElement.setTextContent(name);
            this.setContent(nameElement);
        }
    }

    @Override
    public void setProperties(Properties props) {
        if (props != null) {
            ArrayList<Element> properties = new ArrayList<Element>();
            this.removeContent(this.getChildren("Property", false));
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                Element propertyElement = this.session.createDeploymentElement("Property");
                Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
                Element valueElement = this.session.createDeploymentElement("Value");
                propertyNameElement.setTextContent(key);
                valueElement.setTextContent(value);
                this.session.insertNode((Node)propertyElement, (Node)propertyNameElement, RESULTING_PROPERTY_TYPE);
                this.session.insertNode((Node)propertyElement, (Node)valueElement, RESULTING_PROPERTY_TYPE);
                properties.add(propertyElement);
            }
            this.addContent(properties);
        } else {
            this.unSetElement("Property");
        }
    }

    @Override
    public void setVersion(String version) {
        if (version == null) {
            this.unSetElement("Version");
        } else {
            Element versionElement = this.session.createDeploymentElement("Version");
            versionElement.setTextContent(version);
            this.setContent(versionElement);
        }
    }

    @Override
    public Object clone() {
        return new ResultingResourceMapImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public Condition getCondition() {
        ConditionImpl condition = null;
        if (this.isSetElement("Condition")) {
            Element conditionElement = this.getChild("Condition");
            condition = new ConditionImpl(conditionElement, this.session);
        }
        return condition;
    }

    @Override
    public void setCondition(Condition condition) {
        if (condition == null) {
            this.unSetElement("Condition");
        } else {
            this.setContent((SPIDataObject)((Object)condition));
        }
    }

    @Override
    public Collection<Relationship> getRelationships() {
        Collection<Element> relationshipElements = this.getChildren("Relationship");
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (Element relationshipElement : relationshipElements) {
            relationships.add(new RelationshipImpl(relationshipElement, this.session));
        }
        return relationships;
    }

    @Override
    public void setRelationships(Collection<Relationship> relationships) {
        if (relationships != null && !relationships.isEmpty()) {
            this.removeContent(this.getChildren("Relationship", false));
            this.addContent(relationships);
        } else {
            this.unSetElement("Relationship");
        }
    }
}

