/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionValueImpl
extends SPIDataObject
implements VersionValue {
    private static final String VERSION_VALUE_TYPE = "sdd-dd:VersionValueType";

    public VersionValueImpl(Element data, SPISessionImpl session) {
        super(data, session, VERSION_VALUE_TYPE);
    }

    @Override
    public Collection<String> getFixNames() {
        Collection<Element> fixNameElements = this.getChildren("FixName");
        ArrayList<String> fixNames = new ArrayList<String>();
        for (Element element : fixNameElements) {
            fixNames.add(element.getTextContent());
        }
        return fixNames;
    }

    @Override
    public String getVersion() {
        if (this.isSetElement("Version")) {
            return this.getChild("Version").getTextContent();
        }
        return null;
    }

    @Override
    public void setFixNames(Collection<String> fixNames) {
        this.removeContent(this.getChildren("FixName", false));
        ArrayList<Element> fixNameElements = new ArrayList<Element>();
        for (String fixName : fixNames) {
            Element fixNameElement = this.session.createDeploymentElement("FixName");
            fixNameElement.setTextContent(fixName);
            fixNameElements.add(fixNameElement);
        }
        this.addContent(fixNameElements);
    }

    @Override
    public void setVersion(String version) {
        this.session.testParameter(version, 1, null);
        if (version != null) {
            Element versionElement = this.session.createDeploymentElement("Version");
            versionElement.setTextContent(version);
            this.setContent(versionElement);
        } else {
            this.unSetElement("Version");
        }
    }

    @Override
    public Object clone() {
        return new VersionValueImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

