/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DisplayNameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LanguageSet;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageSetImpl
extends DisplayNameableObject
implements LanguageSet {
    private static final String LANGUAGE_SET_TYPE = "sdd-dd:LanguageSetType";

    public LanguageSetImpl(Element lang, SPISessionImpl session) {
        super(lang, session, LANGUAGE_SET_TYPE);
    }

    @Override
    public Collection<Language> getLanguages() {
        Collection<Element> languageElements = this.getChildren("Language");
        ArrayList<Language> languages = new ArrayList<Language>();
        for (Element element : languageElements) {
            languages.add(new LanguageImpl(element, this.session));
        }
        return languages;
    }

    @Override
    public void setLanguages(Collection<Language> languages) {
        this.session.testParameter(languages, 1, null);
        if (languages != null && !languages.isEmpty()) {
            this.removeContent(this.getChildren("Language", false));
            this.addContent(languages);
        } else {
            this.removeContent(this.getChildren("Language", false));
        }
    }

    @Override
    public Object clone() {
        return new LanguageSetImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

