/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.w3c.dom.Element;

public class InstallableUnitImpl extends InstallUnitImpl implements InstallableUnit {
	private static final String INSTALLABLE_UNIT_TYPE = "sdd-dd:InstallableUnitType";
	private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";
	
    public InstallableUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, INSTALLABLE_UNIT_TYPE);
    }
    
    public String toString() {
        return "IU...\n" + super.toString();
    }

    public Collection<Completion> getInstallableUnitCompletion() {
    	Collection<Element> completionElements = getChildren("Completion");
        Collection<Completion> completions = new ArrayList<Completion>();

        for (Element element : completionElements) {
            completions.add(new CompletionImpl(element, session));
        }

        return completions;
    }

    public Collection<ResultingChange> getResultingChanges() {
    	Collection<Element> resultingChangeElements = getChildren("ResultingChange");
        Collection<ResultingChange> resultingChanges = new ArrayList<ResultingChange>();

        for (Element element : resultingChangeElements) {
            resultingChanges.add(new ResultingChangeImpl(element, session));
        }

        return resultingChanges;
    }

    public Collection<Language> getLanguages() {
    	Collection<Language> languages = new ArrayList<Language>();

        if (isSetElement("Languages")) {
            Collection<Element> languageElementList = session.getChildren(getChild("Languages"), "Language");

            for (Element element : languageElementList) {
                languages.add(new LanguageImpl(element, session));
            }
        }
        
        return languages;
    }

    public void setCompletion(Collection<Completion> installableUnitCompletion) {
    	if (installableUnitCompletion != null && !installableUnitCompletion.isEmpty()) {
            //Remove all Completion elements
            removeContent(getChildren("Completion", false));

            addContent(installableUnitCompletion);
        }
        else {
            //Remove all Completion elements
            removeContent(getChildren("Completion", false));
        }
    }

    public void setResultingChanges(Collection<ResultingChange> newResultingChanges) {
        // TODO error check input, watching for null elements in the array
        
    	if (newResultingChanges != null && !newResultingChanges.isEmpty()) {
            //Remove all ResultingChange elements
            removeContent(getChildren("ResultingChange", false));

            addContent(newResultingChanges);
        }
        else {
            //Remove all ResultingChange elements
            removeContent(getChildren("ResultingChange", false));
        }
    }
    
    // Check against language pattern - http://www.w3.org/TR/xmlschema-2/#language
    public void setLanguages(Collection<Language> languages) {
    	if (languages != null && !languages.isEmpty()) {
            Element languagesElement;

            if (isSetElement("Languages")) {
                languagesElement = getChild("Languages");
            }
            else {
                languagesElement = session.createDeploymentElement("Languages");
            }

            //Remove all Language elements
            Collection<Element> languageNodeList = session.getChildren(languagesElement, "Language");
            for (Element element : languageNodeList) {
                languagesElement.removeChild(element);
            }
            
            for (Language language : languages) {
                session.insertNode(languagesElement, (SPIDataObject) language, LANGUAGES_TYPE);
            }

            setContent(languagesElement);
        }
        else {
            unSetElement("Languages");
        }
    }
}