/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.UniquenessConstraint;
import org.w3c.dom.Element;

public class UniquenessConstraintImpl extends DescribableObject implements UniquenessConstraint {
	private static final String UNIQUENESS_CONSTRAINT_TYPE = "sdd-dd:UniquenessConstraintType";
    
    public UniquenessConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, UNIQUENESS_CONSTRAINT_TYPE);
    }

    public String getDistinctResourceReference() {
        return getAttribute("distinctResourceRef");
    }

    public void setDistinctResourceReference(String ref) {
        session.testParameter(ref, 1, null);

        setAttribute("distinctResourceRef", ref);
    } 

    public Object clone() {
    	return new UniquenessConstraintImpl((Element)getElement().cloneNode(true), session);
    }
}
