/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * Objects implementing the Describable interface may be assigned both
 * descriptions and short descriptions.  While there is no explicit limit
 * to the possible length of a short description, the intent is for short
 * descriptions to be suitable for use as something like tooltip content.
 * 
 * 
 * Note that while the SDD schema allows for the definition of a description
 * without a corresponding short description, the reverse is not true.
 * If short description is set first, then the description is set to the same value. 
 *
 */
public interface Describable extends Translatable {
	/**
	 * Returns the Description.
	 * 
	 * @return the TranslatableString object associated with the describable object
	 */
	TranslatableString getDescription();
	
	/**
	 * Returns the ShortDescription.
	 * 
	 * @return The TranslatableString object associated with the describable object
	 */
	TranslatableString getShortDescription();
	
	/**
	 * Sets the Description.
	 * 
	 * @param description a TranslatableString object to replace the existing description
	 */
	void setDescription(TranslatableString description);
	
	/**
	 * Sets the ShortDescription.
	 * 
	 * @param shortDescription a TranslatableString object to replace the existing ShortDescription
	 *
	 * @throws InvalidInputException If setting ShortDescription when Description is not set
	 *                               and hard error checking is enabled.
	 */
	void setShortDescription(TranslatableString shortDescription) throws InvalidInputException;
}
