/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;


/**
 * When artifact processing requires more than a single file, the artifact declaration includes information about the additional 
 * files needed. AdditionalContentType provides the type definition. Additional content MAY include input files that need to be 
 * edited to include values received as input to a particular solution deployment. In this case, the additional file can include 
 * a Substitution element.
 */
public interface AdditionalContent {
	/**
	 * Gets the content reference.
	 * 
	 * The contentRef attribute points back to the package descriptor for information about the physical file. This value MUST 
	 * match an id of a content element in the package descriptor.
	 * 
	 * @return A reference to the content elements id defined in the package descriptor.
	 */
	String getContentReference();
	
	/**
	 * Gets the type.
	 * 
	 * The type attribute identifies the format of the additional file. Values for this attribute are not defined by this 
	 * specification. ArtifactTypeNameType restricts values of type to valid xsd:QNames.
	 *  
	 * @return Type of the additional artifact file.
	 */
	String getType();
	
	/**
	 * Gets the StringSubstitutions.
	 * 
	 * The Substitution element supports the use of files that require some editing before they can be used in artifact processing. 
	 * The definitions in this element support placement of values determined during a particular deployment into the file identified 
	 * by the contentRef attribute.
	 * 
	 * @return A collection of StringSubstitution objects.
	 */
	Collection<StringSubstitution> getStringSubstitutions();
	 
	/**
	 * Sets the content reference.
	 * 
	 * The contentRef attribute points back to the package descriptor for information about the physical file. This value MUST 
	 * match an id of a content element in the package descriptor.
	 * 
	 * @param contentReference A reference to the content elements id defined in the package descriptor.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setContentReference(String contentReference);
	
	/**
	 * Sets the type.
	 * 
	 * The type attribute identifies the format of the additional file. Values for this attribute are not defined by this 
	 * specification. ArtifactTypeNameType restricts values of type to valid xsd:QNames.
	 * 
	 * @param contentType Type of the additional artifact file.
	 */
	void setType(String contentType);
	
	/**
	 * Sets the StringSubstitutions.
	 * 
	 * The Substitution element supports the use of files that require some editing before they can be used in artifact processing. 
	 * The definitions in this element support placement of values determined during a particular deployment into the file identified 
	 * by the contentRef attribute.
	 * 
	 * @param stringSubstitutions A collection of StringSubstitution objects.
	 */
	void setStringSubstitutions(Collection<StringSubstitution> stringSubstitutions);
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
