/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DisplayNameable;

/**
 * RequiredBaseType provides the type definition for the RequiredBase element of InstallableUnit and LocalizationUnit elements and 
 * the LocalizationBase element of LocalizationUnits. These elements declare the identity characteristics of one or more resources 
 * that will be modified or localized by applying of the content elements artifacts. Definition of a RequiredBase element represents 
 * a requirement that a resource matching the declared characteristic exists. Definition of a LocalizationBase element represents a 
 * condition on the existence of a resource that matches the declared characteristics.
 */
public interface RequiredBase extends DisplayNameable {
	
    /**
     * Gets the required base constraints.
     * 
     * ResourceConstraints defined here identify one or more particular resources that can serve as the update or localization base. 
     * If ResourceConstraints are defined for multiple resources, they are all updated or localized by application of the content 
     * element.
     *  
     * @return Constraints on the required base resource.
     */
    Collection<RequiredBaseConstraint> getRequiredBaseConstraints();
	
    /**
     * Gets the alternative required base constraints.
     * 
     * When more than one resource can be used as the update or localization base, two or more Alternative elements are defined 
     * to describe the choices. As a convenience for tooling that produces SDDs, a single Alternative can be defined in place of 
     * a ResourceConstraint.
     * 
     * @return Alternative collection of constraints on a required base resource.
     */
    Collection<AlternativeRequiredBaseConstraint> getAlternativeRequiredBaseConstraints();
	
	/**
	 * Sets the required base constraints.
	 * 
	 * ResourceConstraints defined here identify one or more particular resources that can serve as the update or localization base. 
     * If ResourceConstraints are defined for multiple resources, they are all updated or localized by application of the content 
     * element.
     *  
	 * @param constraints Constraints on the required base resource.
	 */
	void setRequiredBaseConstraints(Collection<RequiredBaseConstraint> constraints);
	
	/**
	 * Sets the alternative required base constraints.
	 * 
	 * When more than one resource can be used as the update or localization base, two or more Alternative elements are defined 
     * to describe the choices. As a convenience for tooling that produces SDDs, a single Alternative can be defined in place of 
     * a ResourceConstraint.
     * 
	 * @param constraints Alternative collection of constraints on a required base resource.
	 */
	void setAlternativeRequiredBaseConstraints(Collection<AlternativeRequiredBaseConstraint> constraints); 
	
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
