/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement;

import java.util.Properties;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Describable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * A RelationshipConstraint identifies a particular relationship between two resources that is constrained in some way by the SDD. The 
 * value of the testValue attribute of the ResourceConstraint that contains the RelationshipConstraint determines whether the constraint 
 * MUST be satisfied or MUST NOT be satisfied.<br><br>
 * The first resource of the pair is defined by the resourceRef attribute of the ResourceConstraint containing the RelationshipConstraint.
 */
public interface RelationshipConstraint extends Describable {
    /**
     * Gets the properties.
     * 
     * This element MAY be used to provide additional constraints on the relationship.<br><br>
     * <ul>For example, a connectivity relationship might specify additional information such as the specific protocol used (for 
     * instance, TCP/IP) and/or particular characteristics of a protocol (for instance, port number).</ul>
     * 
     * @return A property constraint that further constrains the relationship.
     */
    Properties getProperties();
    
    /**
     * Gets the related resource reference.
     * 
     * Naming the second resource is optional. When it is not named, the relationship constraint is satisfied if the first resource 
     * has the defined relationship with any other resource.<br><br>
     * When it is named, the value MUST reference the id of a resource element in Topology.
     * 
     * @return The second resource in the relationship. 
     */
    String getRelatedResourceReference();
    
    /**
     * Gets the type.
     * 
     * Values for relationship type are not defined by the SDD specification.
     * 
     * @return The type of the relationship.
     */
    String getType();
    
    /**
     * Sets the proerties.
     * 
     * This element MAY be used to provide additional constraints on the relationship.<br><br>
     * <ul>For example, a connectivity relationship might specify additional information such as the specific protocol used (for 
     * instance, TCP/IP) and/or particular characteristics of a protocol (for instance, port number).</ul>
     * 
     * @param props A property constraint that further constrains the relationship.
     */
    void setProperties(Properties props);
    
    /**
     * Sets the related resource reference.
     * 
     * Naming the second resource is optional. When it is not named, the relationship constraint is satisfied if the first resource 
     * has the defined relationship with any other resource.<br><br>
     * When it is named, the value MUST reference the id of a resource element in Topology.
     * 
     * @param ref The second resource in the relationship. 
     */
    void setRelatedResourceRef(String ref);
    
    /**
     * Sets the type.
     * 
     * Values for relationship type are not defined by the SDD specification.
     * 
     * @param type The type of the relationship.
     * @throws InvalidInputException if the parameter is null
     */
    void setType(String type);
     
	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	public Object clone();
}
