/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Describable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * BaseVariableType is the base type of the DerivedVariable and ResourceProperty elements defined by VariablesType. 
 * It provides the id attribute, which is used to reference the variable in a variable expression.
 */
public interface BaseVariable extends Describable {
	/**
	 * Gets the variable ID.
	 * 
	 * Variables may be referenced in deployment descriptor elements of type VariableExpression within the scope of the variable. 
	 * The scope of the variable includes the content element where defined and all nested content elements. Variables defined in 
	 * the top level content element are also visible in Topology. The Variable is referenced by placing the variable id within 
	 * parentheses preceded by a dollar sign.<br><br>
	 * <ul>For example, a variable with id value InstallLocation is referenced with the string $(InstallLocation).</ul>
	 * The id attribute may be useful to software that processes the SDD, for example, for use in creating log and trace messages.
	 * 
	 * @return Identifier used for referencing the variable within the descriptor.
	 */
	String getVariableID();
	
	/**
	 * Gets whether the variable contains sensitive data.
	 * 
	 * The sensitive attribute provides an indication of whether the data within a variable is likely to be considered sensitive. 
	 * User name and password are examples of data that may be considered sensitive. 
	 * <ul>For example, sensitive data typically would not be displayed in a user interface, written to a log file, stored 
	 * without protection, or in any way made visible except to authorized users.</ul>
	 * The default value is false.
	 * 
	 * @return Whether the variable contains sensitive data. A true value indicates the variable contains sensitive data.
	 */
	Boolean isSensitive();
	
	/**
	 * Sets the variable ID.
	 * 
	 * Variables may be referenced in deployment descriptor elements of type VariableExpression within the scope of the variable. 
	 * The scope of the variable includes the content element where defined and all nested content elements. Variables defined in 
	 * the top level content element are also visible in Topology. The Variable is referenced by placing the variable id within 
	 * parentheses preceded by a dollar sign.<br><br>
	 * <ul>For example, a variable with id value InstallLocation is referenced with the string $(InstallLocation).</ul>
	 * The id attribute may be useful to software that processes the SDD, for example, for use in creating log and trace messages.
	 * 
	 * @param Identifier used for referencing the variable within the descriptor.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setVariableID(String id);
	
	/**
	 * Sets whether the variable contains sensitive data.
	 * 
	 * * The sensitive attribute provides an indication of whether the data within a variable is likely to be considered sensitive. 
	 * User name and password are examples of data that may be considered sensitive. 
	 * <ul>For example, sensitive data typically would not be displayed in a user interface, written to a log file, stored 
	 * without protection, or in any way made visible except to authorized users.</ul>
	 * 
	 * @param sensitive A true value indicates the variable contains sensitive data.
	 * <ul>**default value=false</ul>

	 */
	void setSensitive(Boolean sensitive);
}
