/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;

public class DerivedVariableType
{	
	static Collection<DerivedVariable> merge(Collection<DerivedVariable> derived1, Collection<DerivedVariable> derived2)
	{
		// set to hold all the merged variables
		Set<DerivedVariable> merged = new HashSet<DerivedVariable>();
		
		BaseVariableType.merge(derived1, merged);
		BaseVariableType.merge(derived2, merged);
						
		return merged;
	}

	static boolean equals(DerivedVariable b1, DerivedVariable b2)
	{
		boolean equals = true;
		
		// BaseVariable attributes are handled in BaseVariable.equals()
		equals = equals && VariableExpressionType.equals(b1.getExpression(), b2.getExpression());
						
		return equals;
	}	
}