/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Properties;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;

public class RequiredBaseConstraintType {
	
	/*
	 * <RequiredBaseConstraintType> 	 	 	 	
		id 	xsd:ID 	Throw Away
		resourceRef 	xsd:IDREF 	Yes
		testValue 	xsd:boolean 	Yes
		any 	namespace="##other" 	 ?
		DisplayElementGroup 		DisplayElementGroup 	Merge
		Name 		<VariableExpressionType> 	Merge
		VersionConstraint 		<VersionConstraintType> 	Yes
		any 		namespace="##other" 	 ? 
	 */
	
	public static boolean equals( RequiredBaseConstraint constraint1, RequiredBaseConstraint constraint2){
		if (ResourceType.equals(Util.resolveResourceRef(constraint1.getResourceReference()),Util.resolveResourceRef(constraint2.getResourceReference())))
			if (constraint1.getTestValue()==constraint2.getTestValue())				
				return true;
		
		return false;
	}
	
	public static RequiredBaseConstraint merge( RequiredBaseConstraint constraint1, RequiredBaseConstraint constraint2){
		
		TranslatableString description = constraint1.getDescription();
		description.setTranslationKey(description.getTranslationKey()+constraint2.getDescription().getTranslationKey());
		description.setTranslationKey(description.getValue()+constraint2.getDescription().getValue());
		constraint1.setDescription(description);
		
		TranslatableString value = constraint1.getDisplayName();
		value.setTranslationKey(value.getTranslationKey()+constraint2.getDisplayName().getTranslationKey());
		value.setTranslationKey(value.getValue()+constraint2.getDisplayName().getValue());
		constraint1.setDisplayName(value);
		
		return constraint1;
						
	}
}
