/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
/**
 * 
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.rpm;

import java.util.Collection;
import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.rpm.RPMDataCollector;

/**
 *  
 *
 */
public class RPMDataCollector_Test extends TestCase {
	private RPMDataCollector rpmDC = new RPMDataCollector();
	
	/**
	 * @param name
	 */
	public RPMDataCollector_Test(String name) {
		super(name);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetSupportedProperties() throws Exception {
		Collection<BTGProperty> btgp = rpmDC.getSupportedProperties();
		assertTrue(btgp != null);
		assertEquals(btgp.size(), 1);
		assertEquals("FileName", btgp.toArray(new BTGProperty[0])[0].getName());
		assertTrue(btgp.toArray(new BTGProperty[0])[0].isRequired());
	}
	
	public void testValidFileName() {
		Properties props = new Properties();
		props.put("FileName", AllTests.VALID_RPM);
		
		Collection<SDDFragment> sdds = rpmDC.collectSDDData(props);
		assertNotNull(sdds);
		assertEquals(sdds.size(), 2);
		assertTrue(sdds.toArray(new SDDFragment[0])[0].getFragment() instanceof PackageDescriptor);
		assertTrue(sdds.toArray(new SDDFragment[0])[1].getFragment() instanceof DeploymentDescriptor);
	}
	
	public void testInvalidFileName() {
		Properties props = new Properties();
		props.put("FileName", AllTests.ARTIFACTSFILE_LOCATION + "FileNotHere.rpm");
		
		Collection<SDDFragment> sdds = rpmDC.collectSDDData(props);
		assertNull(sdds);
	}
}