/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;

public class ArtifactType {
	
	public static Artifact merge( Artifact artifact1, Artifact artifact2){
		
		if( equals(artifact1,artifact2)){		
			if(!artifact1.getWeight().equals(artifact2.getWeight())){
				//TODO: log weight not equal
				artifact1.setWeight(null);
			}
			
			//TODO:  merge AdditionalContent, OutputVariables, Arguments
			
			return artifact1;
		}
		
		return null;
		
	}
	
	public static boolean equals( Artifact artifact1, Artifact artifact2){
		
		//only return true if both content and resource references are the same
		boolean contentMatch = false;
		boolean resourceMatch = false;
		boolean typeMatch = false;
		
		//must look at the actual content and resources elements and the reference itself
		//TODO Remove Comments around this once packageDescriptor is added
		//PackageContent packageContent1 = Util.resolveContentRef(artifact1.getContentReference());
		//PackageContent packageContent2 = Util.resolveContentRef(artifact2.getContentReference());
		
		/*if( packageContent1 == null || packageContent2 == null){
			//TODO: add log
			return false;
		}
		else if( ContentType.equals(packageContent1, packageContent2) ){
			contentMatch = true;
		}
		else{
			return false;
		}
		*/
		Resource resource1 = Util.resolveResourceRef(artifact1.getResourceReference());
		Resource resource2 = Util.resolveResourceRef(artifact2.getResourceReference());
		
		if( resource1 == null || resource2 == null){
			//TODO: add log
			return false;
		}
		else if( ResourceType.equals(resource1, resource2)){
			resourceMatch = true;
		}
		else{
			return false;
		}
		
		//also check package type
		if(ArtifactTypeNameType.equals(artifact1.getPackageType(), artifact2.getPackageType())){
			typeMatch = true;
		}
		
		if( contentMatch && resourceMatch && typeMatch){
			return true;
		}
		else{
			return false;
		}
	}
}
