/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;



public class RequirementType {

	public static Collection<Requirement> merge(Collection<Requirement> requirements1, Collection<Requirement> requirements2)
	{	
		Collection<Requirement> requirementsToRemove = new ArrayList<Requirement>();
					
		Iterator<Requirement> requirementIter1 = requirements1.iterator();	
		
		while (requirementIter1.hasNext())
		{
			Requirement requirement1 = requirementIter1.next();
			Iterator<Requirement> requirementIter2 = requirements2.iterator();
			while (requirementIter2.hasNext())
			{
				Requirement requirement2 = requirementIter2.next();
				
				if (equals(requirement1, requirement2))
				{
					requirementsToRemove.add(requirement2);
				}
					
			}
		}
		
		requirements2.removeAll(requirementsToRemove);
		
		Collection<Requirement> finalRequirements = new ArrayList<Requirement>();
		finalRequirements.addAll(requirements1);
		finalRequirements.addAll(requirements2);		
		
		return finalRequirements;
		
	}
	
	public static boolean equals(Requirement requirement1, Requirement requirement2)
	{
		
		/*TODO REMOVE ONCE OPERATION TYPE IS DONE
		if (requirement1.getOperations().size()!=requirement2.getOperations().size())
			return false;
		else
	    {
		    Iterator<String> operationIter1 = requirement1.getOperations().iterator();
		    while (operationIter1.hasNext())
		    {			    	
				Iterator<String> operationIter2 = requirement2.getOperations().iterator();
				String operation1 = operationIter1.next();
				boolean foundEquals = false;
				while ((!foundEquals)&&(operationIter2.hasNext()))
				{
				   if (OperationType.equals(operation1,operationIter2.next()))
					   foundEquals = true;					  
				}
				if (!foundEquals)
				   return false;
		    }
	    }
		*/
		
	    
	    if (requirement1.getResourceConstraints().size()!=requirement2.getResourceConstraints().size())
	    	return false;
	    else
	    {
		    Iterator<RequirementResourceConstraint> constraintIter1 = requirement1.getResourceConstraints().iterator();
		    while (constraintIter1.hasNext())
		    {			    	
				Iterator<RequirementResourceConstraint> constraintIter2 = requirement2.getResourceConstraints().iterator();
				RequirementResourceConstraint constraint1 = constraintIter1.next();
				boolean foundEquals = false;
				while ((!foundEquals)&&(constraintIter2.hasNext()))
				{
				   if (RequirementResourceConstraintType.equals(constraint1,constraintIter2.next()))
					   foundEquals = true;					  
				}
				if (!foundEquals)
				   return false;
		    }
	    }
	    
	    
		//TODO couldn't get out "dependency"  ?
		return true;
		
		
	}
}





















