/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;

public class ResultingResourceType {
	
	public static boolean equals(ResultingResource resource1, ResultingResource resource2)
	{		
		Resource resourceRef1 = Util.resolveResourceRef(resource1.getResourceReference());
		Resource resourceRef2 = Util.resolveResourceRef(resource2.getResourceReference());
		if (ResourceType.equals(resourceRef1, resourceRef2))
		{
			if (ConditionType.equalsCondition(resource1.getCondition(),resource2.getCondition()))
			{
			   if (resource1.getVersion().equalsIgnoreCase(resource2.getVersion()))
			   {
			      return true;
			   }
			}
		}
		return false;
	}
	
	

}
