/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts;

import java.io.StringWriter;
import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPropertyId;

/**
 * Represents an identifier for a property
 *  
 * @author David Whiteman
 */
public class PropertyId implements IPropertyId {

	private String localName;
	private URI namespace;
	
	/**
	 * Constructor
	 */
	public PropertyId() {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable#toXML(java.io.StringWriter, int)
	 */
	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.SELECTED_PROPERTY_ELEMENT);
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ICMDBfServicesConstants.NAMESPACE_ATTRIBUTE, getNamespace().toString());
		writer.write(ICMDBfServicesConstants.nl);
		CMDBfServicesUtil.addIndent(writer, indent+1);
		CMDBfServicesUtil.writeAttribute(writer, ICMDBfServicesConstants.LOCAL_NAME_ATTRIBUTE, getLocalName());
		writer.write(ICMDBfServicesConstants.FORWARD_SLASH + ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET + ICMDBfServicesConstants.nl);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPropertyId#getLocalName()
	 */
	public String getLocalName() {
		return localName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPropertyId#setLocalName(java.lang.String)
	 */
	public void setLocalName(String localName) {
		this.localName = localName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPropertyId#getNamespace()
	 */
	public URI getNamespace() {
		return namespace;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IPropertyId#setNamespace(java.net.URI)
	 */
	public void setNamespace(URI namespace) {
		this.namespace = namespace;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result +
				((localName == null) ? 0 : localName.hashCode());
		result = prime * result +
				((namespace == null) ? 0 : namespace.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final PropertyId other = (PropertyId) obj;
		if (localName == null) {
			if (other.localName != null)
				return false;
		} else if (!localName.equals(other.localName))
			return false;
		if (namespace == null) {
			if (other.namespace != null)
				return false;
		} else if (!namespace.equals(other.namespace))
			return false;
		return true;
	}

}
