/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * Represents an instance response to a register or deregister response.
 * The accepted and declined properties are mutually exclusive, i.e. one and
 * only one of the two must be set.
 * 
 * 
 * @author David Whiteman
 */
public interface IInstanceResponse extends IXMLWritable {
	/**
	 * Answer the instance id associated with this response
	 * 
	 * @return
	 */
	public IInstanceId getInstanceId();
	/**
	 * Set the instance id associated with this response
	 * 
	 * @param instanceId
	 */
	public void setInstanceId(IInstanceId instanceId);
	
	/**
	 * Answer the {@link IAccepted} instance for this response.
	 * Either getAccepted() or getDeclined() should return null
	 * for this object.
	 * 
	 * @return
	 */
	public IAccepted getAccepted();

	/**
	 * Set the {@link IAccepted} instance for the receiver.
	 * A response cannot be both accepted and declined.
	 * 
	 * @param accepted
	 */
	public void setAccepted(IAccepted accepted);

	/**
	 * Answer the {@link IDeclined} instance for this response.
	 * Either getAccepted() or getDeclined() should return null
	 * for this object.
	 * 
	 * @return
	 */
	public IDeclined getDeclined();

	/**
	 * Set the {@link IDeclined} instance for the receiver.
	 * A response cannot be both accepted and declined.
	 * 
	 * @param declined
	 */
	public void setDeclined(IDeclined declined);
}
