/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.provisional.datamodel;

import java.util.Iterator;
import java.util.Properties;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Services;
import org.eclipse.cosmos.dc.provisional.datamanager.ConfigurationManager;

public class Group {
    private String host;
    private Services services = new Services();
    private ConfigurationManager _config = new ConfigurationManager();

    public Properties getProperties() {
        return this._config.getOtherProperties();
    }

    public String getName() {
        String n = this._config.getDisplayName();
        return n == null ? null : n.trim();
    }

    public void setName(String name) {
        this._config.setDisplayName(name);
    }

    public String getDescription() {
        String n = this._config.getDescription();
        return n == null ? null : n.trim();
    }

    public void setDescription(String description) {
        this._config.setDescription(description);
    }

    public String getId() {
        String n = this._config.getId();
        return n == null ? null : n.trim();
    }

    public void setId(String id) {
        this._config.setId(id);
    }

    public String getSoapNamespace() {
        String n = this._config.getSoapNamespace();
        return n == null ? null : n.trim();
    }

    public void setSoapNamespace(String soapNamespace) {
        this._config.setSoapNamespace(soapNamespace);
    }

    public String getRecordTypeNamespace() {
        String n = this._config.getRecordTypeNamespace();
        return n == null ? null : n.trim();
    }

    public void setRecordTypeNamespace(String recordTypeNamespace) {
        this._config.setRecordTypeNamespace(recordTypeNamespace);
    }

    public String getSecurityNamespace() {
        String n = this._config.getSecurityNamespace();
        return n == null ? null : n.trim();
    }

    public void setSecurityNamespace(String securityNamespace) {
        this._config.setSecurityNamespace(securityNamespace);
    }

    public String getHost() {
        return this.host == null ? null : this.host.trim();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Services getServices() {
        return this.services;
    }

    public void setServices(Services services) {
        this.services = services;
    }

    public OMElement toOM() {
        String hostid = this.getHost();
        String desc = this.getDescription();
        String name = this.getName();
        String id = this.getId();
        String sns = this.getSoapNamespace();
        String rtns = this.getRecordTypeNamespace();
        String secns = this.getSecurityNamespace();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement groupxml = fac.createOMElement("group", omNs);
        OMElement hostxml = fac.createOMElement("host", omNs, (OMContainer)groupxml);
        OMElement descxml = fac.createOMElement("description", omNs, (OMContainer)groupxml);
        OMElement namexml = fac.createOMElement("name", omNs, (OMContainer)groupxml);
        OMElement idxml = fac.createOMElement("id", omNs, (OMContainer)groupxml);
        OMElement soapNamespacexml = fac.createOMElement("soapNamespace", omNs, (OMContainer)groupxml);
        OMElement recordTypeNamespacexml = fac.createOMElement("recordTypeNamespace", omNs, (OMContainer)groupxml);
        OMElement securityNamespacexml = fac.createOMElement("securityNamespace", omNs, (OMContainer)groupxml);
        fac.createOMText((OMContainer)hostxml, hostid);
        fac.createOMText((OMContainer)descxml, desc);
        fac.createOMText((OMContainer)namexml, name);
        fac.createOMText((OMContainer)idxml, id);
        fac.createOMText((OMContainer)soapNamespacexml, sns);
        fac.createOMText((OMContainer)recordTypeNamespacexml, rtns);
        fac.createOMText((OMContainer)securityNamespacexml, secns);
        if (this.getServices() != null) {
            groupxml.addChild((OMNode)this.getServices().toOM());
        }
        return groupxml;
    }

    public static Group getGroup(OMElement groupxml) {
        Group group = new Group();
        String p = null;
        String t = null;
        Iterator groupIter = groupxml.getChildElements();
        while (groupIter.hasNext()) {
            OMElement elem = (OMElement)groupIter.next();
            if (elem.getLocalName().equals("host")) {
                group.setHost(elem.getText());
            } else if (elem.getLocalName().equals("name")) {
                group.setName(elem.getText());
            } else if (elem.getLocalName().equals("description")) {
                group.setDescription(elem.getText());
            } else if (elem.getLocalName().equals("services")) {
                group.setServices(Services.getServices(elem));
            } else if (elem.getLocalName().equals("id")) {
                group.setId(elem.getText());
            } else if (elem.getLocalName().equals("soapNamespace")) {
                group.setSoapNamespace(elem.getText());
            } else if (elem.getLocalName().equals("recordTypeNamespace")) {
                group.setRecordTypeNamespace(elem.getText());
            } else if (elem.getLocalName().equals("securityNamespace")) {
                group.setSecurityNamespace(elem.getText());
            }
            if (elem.getLocalName().equals("property") && (t = elem.getText()) != null && t.length() > 0) {
                p = new String(t);
            }
            if (!elem.getLocalName().equals("value") || (t = elem.getText()) == null || t.length() <= 0) continue;
            group.getProperties().setProperty(p, t);
        }
        return group;
    }
}

