/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataAggregator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.DeploymentDescriptorType;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregator
implements IBTGDataAggregator {
    Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg");
    Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.tooling.sdd.btg.stdout");
    private static DeploymentDescriptor dd1;
    private static DeploymentDescriptor dd2;
    private static PackageDescriptor pd1;
    private static PackageDescriptor pd2;

    public Collection<BTGProperty> getSupportedProperties() {
        ArrayList<BTGProperty> properties = new ArrayList<BTGProperty>();
        return properties;
    }

    public Collection<Document> aggregateSDDData(Collection<SDDFragment> fragments, Properties properties, boolean allowIncompleteSDDs) {
        try {
            this.consoleLogger.info("welcome to the aggregator");
            SPISession session = SPISession.DEFAULT_INSTANCE;
            dd1 = (DeploymentDescriptor)session.buildDescriptorFromDocument(fragments.iterator().next().getFragment());
            dd2 = (DeploymentDescriptor)session.buildDescriptorFromDocument(fragments.iterator().next().getFragment());
            DeploymentDescriptor resultingDD = DeploymentDescriptorType.merge(dd1, dd2);
            Document doc = resultingDD.getOwnerDocument();
            ArrayList<Document> returnArray = new ArrayList<Document>();
            returnArray.add(doc);
            return returnArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DeploymentDescriptor getDd1() {
        return dd1;
    }

    public static DeploymentDescriptor getDd2() {
        return dd2;
    }

    public static boolean setDd1(DeploymentDescriptor dd) {
        try {
            dd1 = dd;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setDd2(DeploymentDescriptor dd) {
        try {
            dd2 = dd;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Collection<DeploymentDescriptor> getAllDeploymentDescriptors() {
        ArrayList<DeploymentDescriptor> deploymentDescriptors = new ArrayList<DeploymentDescriptor>();
        deploymentDescriptors.add(Aggregator.getDd1());
        deploymentDescriptors.add(Aggregator.getDd2());
        return deploymentDescriptors;
    }

    public static PackageDescriptor getPd1() {
        return pd1;
    }

    public static PackageDescriptor getPd2() {
        return pd2;
    }

    public static boolean setPd1(PackageDescriptor pd) {
        try {
            pd1 = pd;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setPd2(PackageDescriptor pd) {
        try {
            pd2 = pd;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Collection<PackageDescriptor> getAllPackageDescriptors() {
        ArrayList<PackageDescriptor> packageDescriptors = new ArrayList<PackageDescriptor>();
        packageDescriptors.add(Aggregator.getPd1());
        packageDescriptors.add(Aggregator.getPd2());
        return packageDescriptors;
    }
}

