/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.OperationsType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionType {
    static Collection<Completion> merge(Collection<Completion> completion1, Collection<Completion> completion2) {
        ArrayList<Completion> completionsToRemove = new ArrayList<Completion>();
        for (Completion comp1 : completion1) {
            for (Completion comp2 : completion2) {
                if (!CompletionType.equals(comp1, comp2)) continue;
                completionsToRemove.add(comp2);
            }
        }
        completion2.removeAll(completionsToRemove);
        ArrayList<Completion> finalComps = new ArrayList<Completion>();
        finalComps.addAll(completion1);
        finalComps.addAll(completion2);
        return finalComps;
    }

    static boolean equals(Completion c1, Completion c2) {
        boolean equals = true;
        equals = equals && StringType.equals(c1.getCompletionType(), c2.getCompletionType());
        equals = equals && OperationsType.equals(c1.getCompletionOperations(), c2.getCompletionOperations());
        Resource rc1 = Util.resolveResourceRef(c1.getCompletionResourceReference());
        Resource rc2 = Util.resolveResourceRef(c2.getCompletionResourceReference());
        equals = equals && ResourceType.equals(rc1, rc2);
        return equals;
    }
}

