/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ConditionType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultingResourceType {
    public static Collection<ResultingResource> merge(Collection<ResultingResource> resources1, Collection<ResultingResource> resources2) {
        ArrayList<ResultingResource> resourcesToRemove = new ArrayList<ResultingResource>();
        for (ResultingResource resource1 : resources1) {
            for (ResultingResource resource2 : resources2) {
                if (!ResultingResourceType.equals(resource1, resource2)) continue;
                resourcesToRemove.add(resource2);
            }
        }
        resources2.removeAll(resourcesToRemove);
        ArrayList<ResultingResource> finalResources = new ArrayList<ResultingResource>();
        finalResources.addAll(resources1);
        finalResources.addAll(resources2);
        return finalResources;
    }

    public static boolean equals(ResultingResource resource1, ResultingResource resource2) {
        Resource resourceRef2;
        Resource resourceRef1 = Util.resolveResourceRef(resource1.getResourceReference());
        if (!ResourceType.equals(resourceRef1, resourceRef2 = Util.resolveResourceRef(resource2.getResourceReference()))) {
            return false;
        }
        if (resource1.getCondition() == null && resource2.getCondition() != null) {
            return false;
        }
        if (resource1.getCondition() != null && resource2.getCondition() == null) {
            return false;
        }
        if (resource1.getCondition() != null && resource2.getCondition() != null && !ConditionType.equals(resource1.getCondition(), resource2.getCondition())) {
            return false;
        }
        if (resource1.getVersion() == null && resource2.getVersion() != null) {
            return false;
        }
        if (resource1.getVersion() != null && resource2.getVersion() == null) {
            return false;
        }
        return resource1.getVersion() == null || resource2.getVersion() == null || StringType.equals(resource1.getVersion(), resource2.getVersion());
    }
}

