/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.IdentityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ConditionalDerivedVariableImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.DerivedVariableImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ParameterGroupImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ResourcePropertyImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentUnitImpl
extends SPIDataObject
implements ContentUnit {
    private static final String VARIABLES_TYPE = "sdd-dd:VariablesType";

    public ContentUnitImpl(Element data, SPISessionImpl session, String sddSchemaType) {
        super(data, session, sddSchemaType);
    }

    @Override
    public String getContentUnitID() {
        return this.getAttribute("id");
    }

    @Override
    public Identity getIdentityData() {
        IdentityImpl identityData = null;
        if (this.isSetElement("Identity")) {
            identityData = new IdentityImpl(this.getChild("Identity"), this.session);
        }
        return identityData;
    }

    @Override
    public Collection<DerivedVariable> getDerivedVariables() {
        ArrayList<DerivedVariable> derivedVariables = new ArrayList<DerivedVariable>();
        Collection<Element> derivedVariableElements = this.session.getChildren(this.getChild("Variables"), "DerivedVariable");
        for (Element e : derivedVariableElements) {
            if (this.session.getChild(e, "Expression") == null) continue;
            derivedVariables.add(new DerivedVariableImpl(e, this.session));
        }
        return derivedVariables;
    }

    @Override
    public Collection<ConditionalDerivedVariable> getConditionalDerivedVariables() {
        ArrayList<ConditionalDerivedVariable> derivedVariables = new ArrayList<ConditionalDerivedVariable>();
        Collection<Element> derivedVariableElements = this.session.getChildren(this.getChild("Variables"), "DerivedVariable");
        for (Element e : derivedVariableElements) {
            if (this.session.getChild(e, "Expression") != null) continue;
            derivedVariables.add(new ConditionalDerivedVariableImpl(e, this.session));
        }
        return derivedVariables;
    }

    @Override
    public Collection<ResourceProperty> getResourceProperties() {
        ArrayList<ResourceProperty> resourceProperties = new ArrayList<ResourceProperty>();
        Collection<Element> resourcePropertyElements = this.session.getChildren(this.getChild("Variables"), "ResourceProperty");
        for (Element e : resourcePropertyElements) {
            resourceProperties.add(new ResourcePropertyImpl(e, this.session));
        }
        return resourceProperties;
    }

    @Override
    public Collection<ParameterGroup> getParameterGroups() {
        ArrayList<ParameterGroup> parameterGroups = new ArrayList<ParameterGroup>();
        Collection<Element> parameterElements = this.session.getChildren(this.getChild("Variables"), "Parameters");
        for (Element e : parameterElements) {
            parameterGroups.add(new ParameterGroupImpl(e, this.session));
        }
        return parameterGroups;
    }

    @Override
    public void setContentUnitID(String contentUnitID) {
        this.session.testParameter(contentUnitID, 1, null);
        this.setAttribute("id", contentUnitID);
    }

    @Override
    public void setIdentityData(Identity contentUnitIdentity) {
        if (contentUnitIdentity == null) {
            this.unSetElement("Identity");
        } else {
            this.setContent((SPIDataObject)((Object)contentUnitIdentity));
        }
    }

    @Override
    public void setResourceProperties(Collection<ResourceProperty> newResourceProperties) {
        Element variablesElement = null;
        if (this.isSetElement("Variables")) {
            variablesElement = this.getChild("Variables");
            this.session.removeChildren(variablesElement, "ResourceProperty");
        } else {
            variablesElement = this.session.createDeploymentElement("Variables");
        }
        if (newResourceProperties != null && !newResourceProperties.isEmpty()) {
            for (ResourceProperty rp : newResourceProperties) {
                this.session.insertNode((Node)variablesElement, (SPIDataObject)((Object)rp), VARIABLES_TYPE);
            }
        }
        this.setContent(variablesElement);
    }

    @Override
    public void setDerivedVariables(Collection<DerivedVariable> derivedVariables) {
        this.session.testParameter(derivedVariables, 1, null);
        Element variablesElement = null;
        if (this.isSetElement("Variables")) {
            variablesElement = this.getChild("Variables");
            Collection<Element> derivedVariableElements = this.session.getChildren(variablesElement, "DerivedVariable");
            for (Element e : derivedVariableElements) {
                if (this.session.getChild(e, "Expression") == null) continue;
                variablesElement.removeChild(e);
            }
        } else {
            variablesElement = this.session.createDeploymentElement("Variables");
        }
        if (derivedVariables != null && !derivedVariables.isEmpty()) {
            for (DerivedVariable dv : derivedVariables) {
                this.session.insertNode((Node)variablesElement, (SPIDataObject)((Object)dv), VARIABLES_TYPE);
            }
        }
        this.setContent(variablesElement);
    }

    @Override
    public void setConditionalDerivedVariables(Collection<ConditionalDerivedVariable> conditionalDerivedVariables) {
        Element variablesElement = null;
        if (this.isSetElement("Variables")) {
            variablesElement = this.getChild("Variables");
            Collection<Element> derivedVariableElements = this.session.getChildren(variablesElement, "DerivedVariable");
            for (Element e : derivedVariableElements) {
                if (this.session.getChild(e, "Expression") != null) continue;
                variablesElement.removeChild(e);
            }
        } else {
            variablesElement = this.session.createDeploymentElement("Variables");
        }
        if (conditionalDerivedVariables != null && !conditionalDerivedVariables.isEmpty()) {
            for (ConditionalDerivedVariable dv : conditionalDerivedVariables) {
                this.session.insertNode((Node)variablesElement, (SPIDataObject)((Object)dv), VARIABLES_TYPE);
            }
        }
        this.setContent(variablesElement);
    }

    @Override
    public void setParameterGroups(Collection<ParameterGroup> newParameterGroups) {
        Element variablesElement = null;
        if (this.isSetElement("Variables")) {
            variablesElement = this.getChild("Variables");
            this.session.removeChildren(variablesElement, "Parameters");
        } else {
            variablesElement = this.session.createDeploymentElement("Variables");
        }
        if (newParameterGroups != null && !newParameterGroups.isEmpty()) {
            for (ParameterGroup pg : newParameterGroups) {
                this.session.insertNode((Node)variablesElement, (SPIDataObject)((Object)pg), VARIABLES_TYPE);
            }
        }
        this.setContent(variablesElement);
    }

    public String toString() {
        String tmp = new String();
        tmp = "ID: " + this.getContentUnitID() + "\n";
        return tmp;
    }
}

