/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.PropertyType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipType {
    public static Collection<Relationship> merge(Collection<Relationship> relationships1, Collection<Relationship> relationships2) {
        Iterator<Relationship> r1Iter = relationships1.iterator();
        ArrayList<Relationship> rShipsToRemove = new ArrayList<Relationship>();
        while (r1Iter.hasNext()) {
            Relationship r1 = r1Iter.next();
            for (Relationship r2 : relationships2) {
                if (!RelationshipType.equals(r1, r2)) continue;
                rShipsToRemove.add(r2);
            }
        }
        relationships1.addAll(relationships2);
        relationships1.removeAll(rShipsToRemove);
        return relationships1;
    }

    public static boolean equals(Relationship relationship1, Relationship relationship2) {
        if (!ResourceType.equals(Util.resolveResourceRef(relationship1.getRelatedResourceReference()), Util.resolveResourceRef(relationship2.getRelatedResourceReference()))) {
            return false;
        }
        if (!StringType.equals(relationship1.getType(), relationship2.getType())) {
            return false;
        }
        return PropertyType.equals(relationship1.getProperties(), relationship2.getProperties());
    }
}

