/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;

public class ContentType {
	
	public static PackageContent merge( PackageContent content1, PackageContent content2){
		if( equals(content1,content2)){
			//use the contentRef from content1, update all refs that point to content2 to use content1
			Util.updateContentRefs(content2.getContentID(), content1.getContentID());

			return content1;
		}
		
		return null;
		
	}
	
	public static boolean equals( PackageContent content1, PackageContent content2){
		//pathname and content purpose must be the same
		if ((content1==null) ||(content2==null))
			return false;
		
		if ((content1.getPathname()==null) ||(content2.getPathname()==null))
			return false;
		else if (!(StringType.equals(content1.getPathname(), content2.getPathname())))
			return false;
		
		if ((content1.getContentPurpose()==null)&&(content2.getContentPurpose()!=null))
			return false;
		if ((content1.getContentPurpose()!=null)&&(content2.getContentPurpose()==null))
			return false;
		if ((content1.getContentPurpose()==null)&&(content2.getContentPurpose()==null))
			return true;
		if (!(StringType.equals(content1.getContentPurpose(), content2.getContentPurpose())))
			return false;
		
		return true;
	}

}
