/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;



public class DeploymentDescriptorType {
	
	public static DeploymentDescriptor merge(DeploymentDescriptor dd1, DeploymentDescriptor dd2)
	{
		DeploymentDescriptor finaldd = dd1;
		/*DescriptorInfoGroup 	 DescriptorInfoGroup 	 Merge
	Topology 		<TopologyType> 	Merge
	InstallableUnit 		<InstallableUnitType> 	Merge
	ConfigurationUnit 		<ConfigurationUnitType> 	Merge
	LocalizationUnit 		<LocalizationUnitType> 	Merge
	CompositeInstallable 		<CompositeInstallableType> 	Merge
	Requisites 		<RequisitesType> 	Merge 
	*/
		//compare Descriptorinfogroup
		
		finaldd.setResources(TopologyType.merge(dd1.getResources(), dd2.getResources()));
		
		if ((dd1.getContentUnit() instanceof InstallableUnit)&&(dd2.getContentUnit() instanceof InstallableUnit))
			finaldd.setContentUnit(InstallableUnitType.merge((InstallableUnit)dd1.getContentUnit(), (InstallableUnit)dd2.getContentUnit()));
		else if ((dd1.getContentUnit() instanceof LocalizationUnit)&&(dd2.getContentUnit() instanceof LocalizationUnit))
			finaldd.setContentUnit(LocalizationUnitType.merge((LocalizationUnit)dd1.getContentUnit(), (LocalizationUnit)dd2.getContentUnit()));
		else if ((dd1.getContentUnit() instanceof ConfigurationUnit)&&(dd2.getContentUnit() instanceof ConfigurationUnit))
			finaldd.setContentUnit(ConfigurationUnitType.merge((ConfigurationUnit)dd1.getContentUnit(), (ConfigurationUnit)dd2.getContentUnit()));
		//TODO we need to change this to consoleLogger
		else System.out.println("Unable to merge DeploymentDescriptors");
		
		
		
		finaldd.setCompositeInstallables(CompositeInstallableType.merge(dd1.getCompositeInstallables(),dd2.getCompositeInstallables()));
		
		return finaldd;
	}
	
}
