/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;

public class TopologyType {
	
	public static Collection<Resource> merge(Collection<Resource> topology1, Collection<Resource> topology2){
		Collection<Resource> resourcesDuplicates = new ArrayList<Resource>();

		Iterator<Resource> topologyIter1 = topology1.iterator();		
		
		while (topologyIter1.hasNext())
		{
			Resource resource1 = topologyIter1.next();
			Iterator<Resource> topologyIter2 = topology2.iterator();
			while (topologyIter2.hasNext())
			{
				Resource resource2 = topologyIter2.next();
				
				if (ResourceType.equals(resource1, resource2))
				{
					resourcesDuplicates.add(resource2);
				}
					
			}
		}
		
		topology2.removeAll(resourcesDuplicates);
		
		Collection<Resource> finalTopology = new ArrayList<Resource>();
		finalTopology.addAll(topology1);
		finalTopology.addAll(topology2);	
		
		return finalTopology;
		
	}

}
