/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;



public class AdditionalContentType {

	public static AdditionalContent merge(AdditionalContent content1, AdditionalContent content2)
	{	
		/*<AdditionalContentType> 	 	 	 	
		contentRef 	xsd:token 	Yes
		type 	<ArtifactTypeNameType> 	Merge
		any 	namespace="##other" 	 ?
		Substitution 		<SubstitutionType> 	Merge
		any 		namespace="##other" 	 ?
		*/
		
		if (equals(content1,content2))
		{
			content1.setType(StringType.merge(content1.getType(),content2.getType()));
			//TODO substitutions not handled
			return content1;
		}
		return null;
		
	}
	
	
	public static boolean equals (AdditionalContent content1, AdditionalContent content2)
	{	
		if (ContentType.equals(Util.resolveContentRef(content1.getContentReference()),Util.resolveContentRef(content2.getContentReference())))
			   return true;
		return false;
	}
}





















