/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;


import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;



public class AlternativeRequiredBaseConstraintType {

	/*
	 *<AlternativeRequiredBaseConstraintType> 	 	 	 	
		id 	xsd:ID 	Throw Away
		priority 	xsd:positiveInteger 	Merge
		any 	namespace="##other" 	 ?
	DisplayElementGroup 		DisplayElementGroup 	Merge
	ResourceConstraint 		<RequiredBaseConstraintType> 	Yes
	any 		namespace="##other" 	 ? 
	*/
	public static AlternativeRequiredBaseConstraint merge(AlternativeRequiredBaseConstraint constraint1, AlternativeRequiredBaseConstraint constraint2)	 
	{	
		
		if ((constraint1.getPriority()==null)&&(constraint2.getPriority()!=null))
			constraint1.setPriority(constraint2.getPriority());
		else if (constraint2.getPriority()!=null)
		{			
			if (constraint1.getPriority().compareTo(constraint2.getPriority())<0)
				constraint1.setPriority(constraint2.getPriority());			
		}
		
		constraint1.setDescription(TranslatableStringType.merge(constraint1.getDescription(), constraint2.getDescription()));
				
		constraint1.setDisplayName(TranslatableStringType.merge(constraint1.getDisplayName(), constraint2.getDisplayName()));
		
		return constraint1;
		
	}
	
	public static Collection <AlternativeRequiredBaseConstraint> merge(Collection <AlternativeRequiredBaseConstraint> constraints1, Collection <AlternativeRequiredBaseConstraint> constraints2)
	{
		Iterator <AlternativeRequiredBaseConstraint> iter1 = constraints1.iterator();
				
		while (iter1.hasNext())
		{
			AlternativeRequiredBaseConstraint c1 = iter1.next();
			Iterator <AlternativeRequiredBaseConstraint> iter2 = constraints2.iterator();
			
			while (iter2.hasNext())
			{
				AlternativeRequiredBaseConstraint c2 = iter2.next();
				if (equals(c1,c2))
				{
					constraints2.remove(c2);
				}
			}
			
		}
		
		constraints1.addAll(constraints2);
		return constraints1;
		
	}
	
	public static boolean equals(AlternativeRequiredBaseConstraint constraint1, AlternativeRequiredBaseConstraint constraint2)
	{		
		boolean equals = true;
		
		Collection<RequiredBaseConstraint> requiredBaseConstraints1 = constraint1.getRequiredBaseConstraints();
		Collection<RequiredBaseConstraint> requiredBaseConstraints2 = constraint2.getRequiredBaseConstraints();
		
		Iterator<RequiredBaseConstraint> constraintsIter1 = requiredBaseConstraints1.iterator();	
		
		while ((constraintsIter1.hasNext())&&(equals))
		{
			RequiredBaseConstraint baseConstraint1 = constraintsIter1.next();
			
			Iterator<RequiredBaseConstraint> constraintsIter2 = requiredBaseConstraints2.iterator();
			while (constraintsIter2.hasNext())
			{
				RequiredBaseConstraint baseConstraint2 = constraintsIter2.next();				
				if ((RequiredBaseConstraintType.equals(baseConstraint1, baseConstraint2))==false)
				{
					equals=false;
				}				
			}
		}
		
		return equals;
		
	}
}

