/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.math.BigInteger;
import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;

public class ArtifactType {
	
	public static Artifact merge( Artifact artifact1, Artifact artifact2)
	{
	/*
	 <ArtifactType> 	 	 	 	
		contentRef 	xsd:token 	Yes
		resourceRef 	xsd:IDREF 	Yes
		type 	<ArtifactTypeNameType> 	Merge
		weight 	xsd:positiveInteger 	Merge
		any 	namespace="##other" 	 ?
	Arguments 		<ArgumentListType> 	Merge
	OutputVariables 		<OutputVariableListType> 	Merge
	AdditionalContent 		<AdditionalContentType> 	Merge
	any 		namespace="##other" 	 ? 
	 */
		if (equals(artifact1,artifact2))
		{
			artifact1.setPackageType(StringType.merge(artifact1.getPackageType(), artifact2.getPackageType()));
			
			if ((artifact1.getWeight()==null)&&(artifact2.getWeight()!=null))
				artifact1.setWeight(artifact2.getWeight());
			if ((artifact1.getWeight()!=null)&&(artifact2.getWeight()!=null))
				if (artifact1.getWeight().compareTo(artifact2.getWeight())<0)
					artifact1.setWeight(artifact2.getWeight());
			
			//TODO Can't get to argumenttype in spi
			//TODO Can't get to artifactoutputvariables in spi either
			//TODO add additional content comparison
			return artifact1;
		}
		return null;
		
		
	}
	
	public static boolean equals( Artifact artifact1, Artifact artifact2)
	{
		if ((artifact1.getContentReference()==null)&&(artifact1.getContentReference()!=null))
			return false;
		if ((artifact1.getContentReference()!=null)&&(artifact1.getContentReference()==null))
			return false;
		if (!((artifact1.getContentReference()==null)&&(artifact2.getContentReference()==null)))			
			if (!(ContentType.equals(Util.resolveContentRef(artifact1.getContentReference()),Util.resolveContentRef(artifact2.getContentReference()))))
				return false;
		
		if ((artifact1.getResourceReference()==null)&&(artifact1.getResourceReference()!=null))
			return false;
		if ((artifact1.getResourceReference()!=null)&&(artifact1.getResourceReference()==null))
			return false;
		if (!((artifact1.getResourceReference()==null)&&(artifact2.getResourceReference()==null)))			
			if (!(ResourceType.equals(Util.resolveResourceRef(artifact1.getResourceReference()),Util.resolveResourceRef(artifact2.getResourceReference()))))
				return false;
		
		
		return true;
		
	}
}
