/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;

public class ResourcePropertyType
{	
	static Collection<ResourceProperty> merge(Collection<ResourceProperty> derived1, Collection<ResourceProperty> derived2)
	{
		// set to hold all the merged variables
		Set<ResourceProperty> merged = new HashSet<ResourceProperty>();
		
		BaseVariableType.merge(derived1, merged);
		BaseVariableType.merge(derived2, merged);
						
		return merged;
	}

	static boolean equals(ResourceProperty r1, ResourceProperty r2)
	{
		boolean equals = true;
		
		// BaseVariable attributes are handled in BaseVariable.equals()
		equals = equals && StringType.equals(r1.getPropertyName(), r2.getPropertyName());
		equals = equals && StringType.equals(r1.getResourceReference(), r2.getResourceReference());
						
		return equals;
	}
}