/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;

public class ResourceType {

	
	public static Collection merge(Collection resources1, Collection resources2)
	{		
		Collection resourcesToRemove = new ArrayList();
		Iterator resourceIter1 = resources1.iterator();		
		
		while (resourceIter1.hasNext())
		{
			Resource resource1 = (Resource) resourceIter1.next();
			Iterator resourceIter2 = resources2.iterator();
			while (resourceIter2.hasNext())
			{
				Resource resource2 = (Resource) resourceIter2.next();
				
				if (equals(resource1, resource2))
				{
					resourcesToRemove.add(resource2);
				}
					
			}
		}
		
		resources2.removeAll(resourcesToRemove);
		
		Collection finalResources = new ArrayList();
		finalResources.addAll(resources1);
		finalResources.addAll(resources2);		
		
		return finalResources;
		
	}
	
	public static boolean equals(Resource resource1, Resource resource2)
	{		
		if ((resource1==null)||(resource2==null))
			return false;
			
		if (resource1.getResourceType().equalsIgnoreCase(resource2.getResourceType()))
			if (PropertyType.equals(resource1.getProperties(), resource2.getProperties()))
			  if (resource1.getName().equals(resource2.getName()))
				return true;
		return false;
	}
}
