/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;

public class ResultingResourceType {
	/*
	 * <ResultingResourceType> 	 	 	 	
		resourceRef 	xsd:IDREF 	Yes
		any 	namespace="##other" 	 ?
		DescriptionGroup 		DescriptionGroup 	Merge
		Condition 		<ConditionType> 	Yes
		Name 		<VariableExpressionType> 	Merge
		Version 		<VersionType> 	Yes
		FixName 		xsd:string 	Merge
		Property 		<ResultingPropertyType> 	Merge
		Relationship 		<RelationshipType> 	Merge
		any 		namespace="##other" 	 ? 
	 */
	
	public static Collection <ResultingResource> merge (Collection <ResultingResource> resources1, Collection <ResultingResource> resources2)
	{
		Collection resourcesToRemove = new ArrayList();
		Iterator resourceIter1 = resources1.iterator();		
		
		while (resourceIter1.hasNext())
		{
			ResultingResource resource1 = (ResultingResource) resourceIter1.next();
			Iterator resourceIter2 = resources2.iterator();
			while (resourceIter2.hasNext())
			{
				ResultingResource resource2 = (ResultingResource) resourceIter2.next();
				
				if (equals(resource1, resource2))
				{
					resourcesToRemove.add(resource2);
				}
					
			}
		}
		
		resources2.removeAll(resourcesToRemove);
		
		Collection finalResources = new ArrayList();
		finalResources.addAll(resources1);
		finalResources.addAll(resources2);		
		
		return finalResources;
	}
	
	public static boolean equals(ResultingResource resource1, ResultingResource resource2)
	{		
		Resource resourceRef1 = Util.resolveResourceRef(resource1.getResourceReference());
		Resource resourceRef2 = Util.resolveResourceRef(resource2.getResourceReference());
		
		if (!ResourceType.equals(resourceRef1, resourceRef2))
			return false;
		if ((resource1.getCondition()==null)&&(resource2.getCondition()!=null))
			return false;
		if ((resource1.getCondition()!=null)&&(resource2.getCondition()==null))
			return false;
		if ((resource1.getCondition()!=null)&&(resource2.getCondition()!=null))
		{
			if (!ConditionType.equals(resource1.getCondition(),resource2.getCondition()))
				return false;
		}
		
		if ((resource1.getVersion()==null)&&(resource2.getVersion()!=null))
			return false;
		if ((resource1.getVersion()!=null)&&(resource2.getVersion()==null))
			return false;
		if  ((resource1.getVersion()!=null)&&(resource2.getVersion()!=null))
		{						
		   if (!StringType.equals(resource1.getVersion(), resource2.getVersion()))
		       return false;
		}
			
		return true;
	}
	
	

}
