/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Describable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.w3c.dom.Element;

public abstract class DescribableObject extends SPIDataObject implements Describable {
	
	public DescribableObject(Element element, SPISessionImpl session, String sddSchemaType) {
		super(element, session, sddSchemaType);
	}
	
	public TranslatableString getDescription() {
		TranslatableString ts = null;
		
		if (isSetElement("Description")) {
		    ts = new TranslatableString(getChild("Description"));
		}
		
		return ts;
	}

	public TranslatableString getShortDescription() {
		TranslatableString ts = null;
		
		if (isSetElement("ShortDescription")) {
		    ts = new TranslatableString(getChild("ShortDescription"));
		}

		return ts;
	}

	public void setDescription(TranslatableString description) {
	    //TODO: check if ShortDescription is set before trying to unset
		if (description == null) {
		    unSetElement("Description");
		}
		else {
			Element element = session.createCommonElement("Description");
			element.setAttribute("translationKey", description.getTranslationKey());
			element.setTextContent(description.getValue());
			
			setContent(element);
		}
	}
	
	public void setShortDescription(TranslatableString shortDescription) throws InvalidInputException {
        if (shortDescription == null) 
        {
            unSetElement("ShortDescription");
        }
        else 
        {
            Element element = session.createCommonElement("ShortDescription");
            element.setAttribute("translationKey", shortDescription.getTranslationKey());
            element.setTextContent(shortDescription.getValue());
			
			setContent(element);
            
            if (!isSetElement("Description") && session.isErrorCheckingEnabled()) {
                // There can be no short description without a regular description.
            	// Throw an exception
            	throw new InvalidInputException(1, InvalidInputException.INVALID_VALUE);
            }
        }
	}
	
	public String toString() {
		String temp = new String();
		Element descriptionElement = getChild("Description");
		Element shortDescriptionElement = getChild("ShortDescription");

		if (descriptionElement != null) {
			temp += "Description - \"" + descriptionElement.getTextContent() + "\"\n";
			
			if (shortDescriptionElement != null) {
				temp += "Short Description - \"" + shortDescriptionElement.getTextContent() + "\"\n";
			}
			else {
				temp += "Short Description - not defined\n";
			}
		}
		else {	
			temp += "No description defined\n";
		}
		
		return temp;
	}
}
