/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResourceMap;
import org.w3c.dom.Element;

public class ResourceMapImpl extends SPIDataObject implements ResourceMap {
	private static final String RESOURCE_MAP_TYPE = "sdd-dd:ResourceMapType";
	
	public ResourceMapImpl(Element rmdo, SPISessionImpl session) {
        super(rmdo, session, RESOURCE_MAP_TYPE);
    }
    
	public ResourceMapImpl(Element rmdo, SPISessionImpl session, String sddSchemaType) {
        super(rmdo, session, sddSchemaType);
    }

    public String getForeignID() {
   		return getAttribute("foreignId");
    }

    public String getResourceReference() {
   		return getAttribute("resourceRef");
    }

    public void setForeignID(String id) {
       	setAttribute("foreignId", id);
    }

    public void setResourceReference(String reference) {
        session.testParameter(reference, 1, null);

        setAttribute("resourceRef", reference);
    }

    public Object clone() {
    	return new ResourceMapImpl((Element)getElement().cloneNode(true), session);
    }
}
