/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.w3c.dom.Element;

public class RequiredBaseImpl extends NameableObject implements RequiredBase {
	private static final String REQUIRED_BASE_TYPE = "sdd-dd:RequiredBaseType";
	
	public RequiredBaseImpl(Element data, SPISessionImpl session) {
		super(data, session, REQUIRED_BASE_TYPE);
	}
	
	public Collection<AlternativeRequiredBaseConstraint> getAlternativeRequiredBaseConstraints() {
		Collection<Element> constraintElements = getChildren("Alternative");
		Collection<AlternativeRequiredBaseConstraint> constraints =
			new ArrayList<AlternativeRequiredBaseConstraint>();
		
		for (Element constraintElement : constraintElements) {
			AlternativeRequiredBaseConstraint constraint =
				new AlternativeRequiredBaseConstraintImpl(constraintElement, session);
			constraints.add(constraint);
		}
		
		return constraints;
	}

	public Collection<RequiredBaseConstraint> getRequiredBaseConstraints() {
		Collection<Element> constraintElements = getChildren("ResourceConstraint");
		Collection<RequiredBaseConstraint> constraints = new ArrayList<RequiredBaseConstraint>();
		
		for (Element constraintElement : constraintElements) {
			RequiredBaseConstraint constraint = new RequiredBaseConstraintImpl(constraintElement, session);
			constraints.add(constraint);
		}
		
		return constraints;
	}

	public void setAlternativeRequiredBaseConstraints(Collection<AlternativeRequiredBaseConstraint> constraints) {
		if (constraints == null) {
			unSetElement("Alternative");
		}
		else {
			removeContent(getChildren("Alternative", false));
			
			addContent(constraints);
		}
	}

	public void setRequiredBaseConstraints(Collection<RequiredBaseConstraint> constraints) {
		if (constraints == null) {
			unSetElement("ResourceConstraint");
		}
		else {
			removeContent(getChildren("ResourceConstraint", false));
			
			addContent(constraints);
		}
	}

	public Object clone() {
		return new RequiredBaseImpl((Element)getElement().cloneNode(true), session);
	}
}
