/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Formatter;
import java.util.Properties;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


public class ConversionUtil {
	public static Properties getPropertiesFromPropertyElementList(Collection<Element> propertyElementList) {
		Properties p = new Properties();
		SPISessionImpl session = SPISessionImpl.getDefaultSession();
		
		if (propertyElementList != null) {
			for (Element propertyElement : propertyElementList) {
			    Element propertyNameElement = session.getChild(propertyElement, "PropertyName");
			    Element valueElement = session.getChild(propertyElement, "Value");
				
				String propertyName = null;
                String value = null;

                if (propertyNameElement != null) {
                    propertyName = propertyNameElement.getTextContent();
                }

                if (valueElement != null) {
                    value = valueElement.getTextContent();
                }

                if (propertyName != null && value != null) {
                    p.put(propertyName, value);
				}
			}
		}
		
		return p;
	}

	public static Properties dumpStrings(Node data) {
		Properties xStrings = new Properties();
		
		if (data instanceof Document) {
			NodeList children = data.getChildNodes();
			
			for (int i = 0; i < children.getLength(); i++) {
				Node child = children.item(i);
			
				if (child instanceof Element) {
					Properties props = dumpStrings((Element)children.item(i));
					xStrings.putAll(props);
				}
			}				
		}
		else if (data instanceof Element) {
			String translationKey = ((Element)data).getAttribute("translationKey");
			String value = data.getTextContent();
		
			if (translationKey != null && translationKey.length() > 0 && value != null && value.length() > 0) {
				xStrings.put(translationKey, value);
			}
			else {
				NodeList children = data.getChildNodes();
			
				for (int i = 0; i < children.getLength(); i++) {
					Node child = children.item(i);
				
					if (child instanceof Element) {
						Properties props = dumpStrings((Element)children.item(i));
						xStrings.putAll(props);
					}
				}	
			}
		}
		
		return xStrings;		
	}
	
    public static String bytesToHex(byte[] bytes) {
        Formatter formatter = new Formatter();
        
        for (byte b : bytes) {
            formatter.format("%02X", b);
        }
        
        return formatter.toString();
    }
    
    public static byte[] hexToBytes(String hexString) {
    	BigInteger bigInt = new BigInteger(hexString, 16);
    	
    	return bigInt.toByteArray();
    }
}