/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentUnitFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.w3c.dom.Element;

public class CompositeLocalizationUnit_Test extends TestCase
{
    CompositeLocalizationUnit unit;
    CompositeLocalizationUnit clonedUnit;
    Element element;
    SPISessionImpl session;

    public CompositeLocalizationUnit_Test(String name)
    {
        super(name);
    }

    protected void setUp() throws Exception
    {
        super.setUp();

        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art1.setContentReference("art1ContentRef");
        LocalizationUnit lu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu1ID", "lu1ResourceRef", art1, ContentUnitFactory.INSTALL_ARTIFACT);
        Artifact art2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art2.setContentReference("art2ContentRef");
        LocalizationUnit lu2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu2ID", "lu2ResourceRef", art2, ContentUnitFactory.INSTALL_ARTIFACT);
        unit = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithLocalizationUnits("unitID", Arrays.asList(lu1, lu2));
        
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("conName", "conNameKey"));
        unit.setCondition(condition);

        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con1Name", "con1NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp1Expression", con1);
        Condition con2 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con2.setDisplayName(new TranslatableString("con2Name", "con2NameKey"));
        ConditionalDerivedVariableExpression exp2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp2Expression", con2);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var1ID", Arrays.asList(exp1, exp2));

        Condition con3 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con3.setDisplayName(new TranslatableString("con3Name", "con3NameKey"));
        ConditionalDerivedVariableExpression exp3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con3);
        Condition con4 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con4.setDisplayName(new TranslatableString("con4Name", "con4NameKey"));
        ConditionalDerivedVariableExpression exp4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp4Expression", con4);
        ConditionalDerivedVariable var2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var2ID", Arrays.asList(exp3, exp4));
        unit.setConditionalDerivedVariables(Arrays.asList(var1, var2));
        
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar1ID", "dvar1Expression");
        DerivedVariable dvar2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar2ID", "dvar2Expression");
        unit.setDerivedVariables(Arrays.asList(dvar1, dvar2));
        
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("name", "nameKey"));
        unit.setIdentityData(identity);
        
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param1ID");
        BooleanParameter param2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param2ID");
        ParameterGroup group1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group1.setBooleanParameters(Arrays.asList(param1, param2));
        BooleanParameter param3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param3ID");
        BooleanParameter param4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param4ID");
        ParameterGroup group2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group2.setBooleanParameters(Arrays.asList(param3, param4));
        unit.setParameterGroups(Arrays.asList(group1, group2));
        
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req1ID");
        Requirement req2 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req2ID");
        unit.setRequirements(Arrays.asList(req1, req2));
        
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop1ID", "prop1Ref");
        ResourceProperty prop2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop2ID", "prop2Ref");
        unit.setResourceProperties(Arrays.asList(prop1, prop2));

        Completion comp1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompletion("comp1Type", "comp1Ref");
        Completion comp2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompletion("comp2Type", "comp2Ref");
        unit.setCompletions(Arrays.asList(comp1, comp2));

        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package1Ref", "package1ID");
        ReferencedPackage package2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package2Ref", "package2ID");
        unit.setContainedLocalizationPackages(Arrays.asList(package1, package2));

        ReferencedPackage package3 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package3Ref", "package3ID");
        ReferencedPackage package4 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package4Ref", "package4ID");
        CompositeLocalizationUnit comploc1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc1ID", Arrays.asList(package3, package4));
        ReferencedPackage package5 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package5Ref", "package5ID");
        ReferencedPackage package6 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package6Ref", "package6ID");
        CompositeLocalizationUnit comploc2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc2ID", Arrays.asList(package5, package6));
        unit.setCompositeLocalizationUnits(Arrays.asList(comploc1, comploc2));

        ResultingResource res1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res1Ref");
        ResultingResource res2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res2Ref");
        unit.setResultingResources(Arrays.asList(res1, res2));
        
        RequiredBase base = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createRequiredBase();
        base.setDisplayName(new TranslatableString("baseName", "baseKey"));
        unit.setRequiredBase(base);
        
        RequiredBase locBase = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createLocalizationBase();
        locBase.setDisplayName(new TranslatableString("locBaseName", "locBaseKey"));
        unit.setLocalizationBase(locBase);

        Language lang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang1Type");
        Language lang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang2Type");
        unit.setLanguages(Arrays.asList(lang1, lang2));
        
        clonedUnit = (CompositeLocalizationUnit) unit.clone();
        element = ((SPIDataObject) unit).getElement();
        session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings()
    {
        Properties props = ((SPIDataObject) unit).getTranslatableStrings();
        
        assertEquals(8, props.size());
        assertEquals("conName", props.getProperty("conNameKey"));
        assertEquals("con1Name", props.getProperty("con1NameKey"));
        assertEquals("con2Name", props.getProperty("con2NameKey"));
        assertEquals("con3Name", props.getProperty("con3NameKey"));
        assertEquals("con4Name", props.getProperty("con4NameKey"));
        assertEquals("name", props.getProperty("nameKey"));
        assertEquals("baseName", props.getProperty("baseKey"));
        assertEquals("locBaseName", props.getProperty("locBaseKey"));
    }

    public void testGetCompletions()
    {
        assertEquals(2, unit.getCompletions().size());
        assertEquals("comp1Type", unit.getCompletions().toArray(new Completion[0])[0].getCompletionType());
        assertEquals("comp1Ref", unit.getCompletions().toArray(new Completion[0])[0].getCompletionResourceReference());
        assertEquals("comp2Type", unit.getCompletions().toArray(new Completion[0])[1].getCompletionType());
        assertEquals("comp2Ref", unit.getCompletions().toArray(new Completion[0])[1].getCompletionResourceReference());

        assertEquals(2, clonedUnit.getCompletions().size());
        assertEquals("comp1Type", clonedUnit.getCompletions().toArray(new Completion[0])[0].getCompletionType());
        assertEquals("comp1Ref", clonedUnit.getCompletions().toArray(new Completion[0])[0].getCompletionResourceReference());
        assertEquals("comp2Type", clonedUnit.getCompletions().toArray(new Completion[0])[1].getCompletionType());
        assertEquals("comp2Ref", clonedUnit.getCompletions().toArray(new Completion[0])[1].getCompletionResourceReference());

        assertEquals(2, session.getChildren(element, "Completion").size());
        assertEquals("comp1Type", ( session.getChildren(element, "Completion").toArray(new Element[0])[0]).getAttribute("type"));
        assertEquals("comp1Ref", ( session.getChildren(element, "Completion").toArray(new Element[0])[0]).getAttribute("resourceRef"));
        assertEquals("comp2Type", ( session.getChildren(element, "Completion").toArray(new Element[0])[1]).getAttribute("type"));
        assertEquals("comp2Ref", ( session.getChildren(element, "Completion").toArray(new Element[0])[1]).getAttribute("resourceRef"));
    }

    public void testGetCompositeLocalizationUnits()
    {
        assertEquals(2, unit.getCompositeLocalizationUnits().size());
        assertEquals(2, unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        assertEquals(2, unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().size());
        assertEquals("comploc1ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        assertEquals("package3ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package3Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package4ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package4Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        assertEquals("comploc2ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContentUnitID());
        assertEquals("package5ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package5Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package6ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package6Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, clonedUnit.getCompositeLocalizationUnits().size());
        assertEquals(2, clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        assertEquals(2, clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().size());
        assertEquals("comploc1ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        assertEquals("package3ID", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package3Ref", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package4ID", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package4Ref", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        assertEquals("comploc2ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContentUnitID());
        assertEquals("package5ID", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package5Ref", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package6ID", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package6Ref", clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, session.getChildren(element, "CompositeLocalizationUnit").size());
        assertEquals(2, session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        assertEquals(2, session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").size());
        assertEquals("comploc1ID", session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package3ID", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package3Ref", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("package4ID", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("package4Ref", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
        assertEquals("comploc2ID", ( session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[1]).getAttribute("id"));
        assertEquals("package5ID", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package5Ref", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("package6ID", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("package6Ref", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetCondition()
    {
        assertEquals("conName", unit.getCondition().getDisplayName().getValue());
        assertEquals("conNameKey", unit.getCondition().getDisplayName().getTranslationKey());

        assertEquals("conName", clonedUnit.getCondition().getDisplayName().getValue());
        assertEquals("conNameKey", clonedUnit.getCondition().getDisplayName().getTranslationKey());

        assertEquals("conName", session.getChildren(session.getChildren(element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("conNameKey", session.getChildren(session.getChildren(element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetContainedLocalizationPackages()
    {
        assertEquals(2, unit.getContainedLocalizationPackages().size());
        assertEquals("package1ID", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package1Ref", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package2ID", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package2Ref", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, clonedUnit.getContainedLocalizationPackages().size());
        assertEquals("package1ID", clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package1Ref", clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        assertEquals("package2ID", clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        assertEquals("package2Ref", clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());

        assertEquals(2, session.getChildren(element, "ContainedLocalizationPackage").size());
        assertEquals("package1ID", ( session.getChildren(element, "ContainedLocalizationPackage").toArray(new Element[0])[0]).getAttribute("id"));
        assertEquals("package1Ref", ( session.getChildren(element, "ContainedLocalizationPackage").toArray(new Element[0])[0]).getAttribute("contentRef"));
        assertEquals("package2ID", ( session.getChildren(element, "ContainedLocalizationPackage").toArray(new Element[0])[1]).getAttribute("id"));
        assertEquals("package2Ref", ( session.getChildren(element, "ContainedLocalizationPackage").toArray(new Element[0])[1]).getAttribute("contentRef"));
    }

    public void testGetLocalizationBase()
    {
        assertEquals("locBaseName", unit.getLocalizationBase().getDisplayName().getValue());
        assertEquals("locBaseKey", unit.getLocalizationBase().getDisplayName().getTranslationKey());

        assertEquals("locBaseName", clonedUnit.getLocalizationBase().getDisplayName().getValue());
        assertEquals("locBaseKey", clonedUnit.getLocalizationBase().getDisplayName().getTranslationKey());

        assertEquals("locBaseName", session.getChildren(session.getChildren(element, "LocalizationBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("locBaseKey", session.getChildren(session.getChildren(element, "LocalizationBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetLocalizationUnits()
    {
        assertEquals(2, unit.getLocalizationUnits().size());
        assertEquals("lu1ID", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        assertEquals("lu1ResourceRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        assertEquals("art1ContentRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        assertEquals("lu2ID", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getContentUnitID());
        assertEquals("lu2ResourceRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getTargetResourceReference());
        assertEquals("art2ContentRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getInstallArtifact().getContentReference());

        assertEquals(2, clonedUnit.getLocalizationUnits().size());
        assertEquals("lu1ID", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        assertEquals("lu1ResourceRef", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        assertEquals("art1ContentRef", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        assertEquals("lu2ID", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getContentUnitID());
        assertEquals("lu2ResourceRef", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getTargetResourceReference());
        assertEquals("art2ContentRef", clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getInstallArtifact().getContentReference());

        assertEquals(2, session.getChildren(element, "LocalizationUnit").size());
        assertEquals("lu1ID", session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("lu1ResourceRef", session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("art1ContentRef", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        assertEquals("lu2ID", session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("lu2ResourceRef", session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        assertEquals("art2ContentRef", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetRequiredBase()
    {
        assertEquals("baseName", unit.getRequiredBase().getDisplayName().getValue());
        assertEquals("baseKey", unit.getRequiredBase().getDisplayName().getTranslationKey());
        
        assertEquals("baseName", clonedUnit.getRequiredBase().getDisplayName().getValue());
        assertEquals("baseKey", clonedUnit.getRequiredBase().getDisplayName().getTranslationKey());

        assertEquals("baseName", session.getChildren(session.getChildren(element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("baseKey", session.getChildren(session.getChildren(element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetRequirements()
    {
        assertEquals(2, unit.getRequirements().size());
        assertEquals("req1ID", unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        assertEquals("req2ID", unit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());
        
        assertEquals(2, clonedUnit.getRequirements().size());
        assertEquals("req1ID", clonedUnit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        assertEquals("req2ID", clonedUnit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());

        assertEquals(2, session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        assertEquals("req1ID", session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("req2ID", session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetResultingResources()
    {
        assertEquals(2, unit.getResultingResources().size());
        assertEquals("res1Ref", unit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        assertEquals("res2Ref", unit.getResultingResources().toArray(new ResultingResource[0])[1].getResourceReference());
        
        assertEquals(2, clonedUnit.getResultingResources().size());
        assertEquals("res1Ref", clonedUnit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        assertEquals("res2Ref", clonedUnit.getResultingResources().toArray(new ResultingResource[0])[1].getResourceReference());

        assertEquals(2, session.getChildren(element, "ResultingResource").size());
        assertEquals("res1Ref", ( session.getChildren(element, "ResultingResource").toArray(new Element[0])[0]).getAttribute("resourceRef"));
        assertEquals("res2Ref", ( session.getChildren(element, "ResultingResource").toArray(new Element[0])[1]).getAttribute("resourceRef"));
    }

    public void testGetLanguages()
    {
        assertEquals(2, unit.getLanguages().size());
        assertEquals("lang1Type", unit.getLanguages().toArray(new Language[0])[0].getType());
        assertEquals("lang2Type", unit.getLanguages().toArray(new Language[0])[1].getType());
        
        assertEquals(2, clonedUnit.getLanguages().size());
        assertEquals("lang1Type", clonedUnit.getLanguages().toArray(new Language[0])[0].getType());
        assertEquals("lang2Type", clonedUnit.getLanguages().toArray(new Language[0])[1].getType());

        assertEquals(2, session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Language").size());
        assertEquals("lang1Type", session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        assertEquals("lang2Type", session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetContentUnitID()
    {
        assertEquals("unitID", unit.getContentUnitID());
        assertEquals("unitID", clonedUnit.getContentUnitID());
        assertEquals("unitID", element.getAttribute("id"));
    }

    public void testGetIdentityData()
    {
        assertEquals("name", unit.getIdentityData().getName().getValue());
        assertEquals("nameKey", unit.getIdentityData().getName().getTranslationKey());
        
        assertEquals("name", clonedUnit.getIdentityData().getName().getValue());
        assertEquals("nameKey", clonedUnit.getIdentityData().getName().getTranslationKey());

        assertEquals("name", session.getChildren(session.getChildren(element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        assertEquals("nameKey", session.getChildren(session.getChildren(element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDerivedVariables()
    {
        assertEquals(2, unit.getDerivedVariables().size());
        assertEquals("dvar1ID", unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar1Expression", unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar2ID", unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        assertEquals("dvar2Expression", unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());

        assertEquals(2, clonedUnit.getDerivedVariables().size());
        assertEquals("dvar1ID", clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar1Expression", clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        assertEquals("dvar2ID", clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        assertEquals("dvar2Expression", clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());

        assertEquals(4, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        assertEquals("dvar1ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        assertEquals("dvar1Expression", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("dvar2ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3].getAttribute("id"));
        assertEquals("dvar2Expression", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetConditionalDerivedVariables()
    {
        assertEquals(2, unit.getConditionalDerivedVariables().size());
        assertEquals("var1ID", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        assertEquals("exp1Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con1Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con1NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        assertEquals("exp2Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        assertEquals("con2Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        assertEquals("con2NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        assertEquals("var2ID", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        assertEquals("exp3Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con3Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con3NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        assertEquals("exp4Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        assertEquals("con4Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        assertEquals("con4NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());

        assertEquals(2, clonedUnit.getConditionalDerivedVariables().size());
        assertEquals("var1ID", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        assertEquals("exp1Expression", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con1Name", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con1NameKey", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        assertEquals("exp2Expression", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        assertEquals("con2Name", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        assertEquals("con2NameKey", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        assertEquals("var2ID", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        assertEquals("exp3Expression", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con3Name", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con3NameKey", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        assertEquals("exp4Expression", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        assertEquals("con4Name", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        assertEquals("con4NameKey", clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());

        assertEquals(4, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        assertEquals("var1ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("exp1Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con1Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con1NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        assertEquals("exp2Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con2Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con2NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        assertEquals("var2ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("exp3Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con3Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con3NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        assertEquals("exp4Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con4Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con4NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetResourceProperties()
    {
        assertEquals(2, unit.getResourceProperties().size());
        assertEquals("prop1ID", unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        assertEquals("prop1Ref", unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        assertEquals("prop2ID", unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        assertEquals("prop2Ref", unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());

        assertEquals(2, clonedUnit.getResourceProperties().size());
        assertEquals("prop1ID", clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        assertEquals("prop1Ref", clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        assertEquals("prop2ID", clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        assertEquals("prop2Ref", clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());

        assertEquals(2, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        assertEquals("prop1ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("prop1Ref", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
        assertEquals("prop2ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("prop2Ref", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetParameterGroups()
    {
        assertEquals(2, unit.getParameterGroups().size());
        assertEquals(2, unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        assertEquals(2, unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        assertEquals("param1ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        assertEquals("param2ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        assertEquals("param3ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        assertEquals("param4ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());

        assertEquals(2, clonedUnit.getParameterGroups().size());
        assertEquals(2, clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        assertEquals(2, clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        assertEquals("param1ID", clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        assertEquals("param2ID", clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        assertEquals("param3ID", clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        assertEquals("param4ID", clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());

        assertEquals(2, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        assertEquals(2, session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").size());
        assertEquals("param1ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("param2ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
        assertEquals("param3ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("param4ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testSetCompletions()
    {
        Completion comp1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompletion("comp3Type", "comp3Ref");
        unit.setCompletions(Arrays.asList(comp1));

        assertEquals(1, unit.getCompletions().size());
        assertEquals("comp3Type", unit.getCompletions().toArray(new Completion[0])[0].getCompletionType());
        assertEquals("comp3Ref", unit.getCompletions().toArray(new Completion[0])[0].getCompletionResourceReference());

        assertEquals(1, session.getChildren(element, "Completion").size());
        assertEquals("comp3Type", ( session.getChildren(element, "Completion").toArray(new Element[0])[0]).getAttribute("type"));
        assertEquals("comp3Ref", ( session.getChildren(element, "Completion").toArray(new Element[0])[0]).getAttribute("resourceRef"));
    }

    public void testSetCompositeLocalizationUnits()
    {
        ReferencedPackage package8 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package8Ref", "package8ID");
        CompositeLocalizationUnit comploc3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc3ID", Arrays.asList(package8));
        unit.setCompositeLocalizationUnits(Arrays.asList(comploc3));

        assertEquals(1, unit.getCompositeLocalizationUnits().size());
        assertEquals(1, unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        assertEquals("comploc3ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        assertEquals("package8ID", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package8Ref", unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());

        assertEquals(1, session.getChildren(element, "CompositeLocalizationUnit").size());
        assertEquals(1, session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        assertEquals("comploc3ID", session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package8ID", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("package8Ref", session.getChildren(session.getChildren(element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetCondition()
    {
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        unit.setCondition(condition);
        
        assertEquals("differentName", unit.getCondition().getDisplayName().getValue());
        assertEquals("differentNameKey", unit.getCondition().getDisplayName().getTranslationKey());

        assertEquals("differentName", session.getChildren(session.getChildren(element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("differentNameKey", session.getChildren(session.getChildren(element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetContainedLocalizationPackages()
    {
        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package7Ref", "package7ID");
        unit.setContainedLocalizationPackages(Arrays.asList(package1));

        assertEquals(1, unit.getContainedLocalizationPackages().size());
        assertEquals("package7ID", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        assertEquals("package7Ref", unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());

        assertEquals(1, session.getChildren(element, "ContainedLocalizationPackage").size());
        assertEquals("package7ID", ( session.getChildren(element, "ContainedLocalizationPackage").toArray(new Element[0])[0]).getAttribute("id"));
        assertEquals("package7Ref", ( session.getChildren(element, "ContainedLocalizationPackage").toArray(new Element[0])[0]).getAttribute("contentRef"));
    }

    public void testSetLocalizationBase()
    {
        RequiredBase locBase = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createLocalizationBase();
        locBase.setDisplayName(new TranslatableString("differentBaseName", "differentBaseKey"));
        unit.setLocalizationBase(locBase);
        
        assertEquals("differentBaseName", unit.getLocalizationBase().getDisplayName().getValue());
        assertEquals("differentBaseKey", unit.getLocalizationBase().getDisplayName().getTranslationKey());

        assertEquals("differentBaseName", session.getChildren(session.getChildren(element, "LocalizationBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("differentBaseKey", session.getChildren(session.getChildren(element, "LocalizationBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetLocalizationUnits()
    {
        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art1.setContentReference("art3ContentRef");
        LocalizationUnit lu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu3ID", "lu3ResourceRef", art1, ContentUnitFactory.INSTALL_ARTIFACT);
        unit.setLocalizationUnits(Arrays.asList(lu1));
        
        assertEquals(1, unit.getLocalizationUnits().size());
        assertEquals("lu3ID", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        assertEquals("lu3ResourceRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        assertEquals("art3ContentRef", unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());

        assertEquals(1, session.getChildren(element, "LocalizationUnit").size());
        assertEquals("lu3ID", session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("lu3ResourceRef", session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        assertEquals("art3ContentRef", session.getChildren(session.getChildren(session.getChildren(element, "LocalizationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetRequiredBase()
    {
        RequiredBase base = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createRequiredBase();
        base.setDisplayName(new TranslatableString("differentName", "differentKey"));
        unit.setRequiredBase(base);
        
        assertEquals("differentName", unit.getRequiredBase().getDisplayName().getValue());
        assertEquals("differentKey", unit.getRequiredBase().getDisplayName().getTranslationKey());
        
        assertEquals("differentName", session.getChildren(session.getChildren(element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("differentKey", session.getChildren(session.getChildren(element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetRequirements()
    {
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req3ID");
        unit.setRequirements(Arrays.asList(req1));
        
        assertEquals(1, unit.getRequirements().size());
        assertEquals("req3ID", unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());

        assertEquals(1, session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        assertEquals("req3ID", session.getChildren(session.getChildren(element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetResultingResources()
    {
        ResultingResource res1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res3Ref");
        unit.setResultingResources(Arrays.asList(res1));

        assertEquals(1, unit.getResultingResources().size());
        assertEquals("res3Ref", unit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());

        assertEquals(1, session.getChildren(element, "ResultingResource").size());
        assertEquals("res3Ref", session.getChildren(element, "ResultingResource").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetLanguages()
    {
        Language lang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang3Type");
        unit.setLanguages(Arrays.asList(lang1));

        assertEquals(1, unit.getLanguages().size());
        assertEquals("lang3Type", unit.getLanguages().toArray(new Language[0])[0].getType());

        assertEquals(1, session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Language").size());
        assertEquals("lang3Type", session.getChildren(session.getChildren(element, "Languages").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetContentUnitID()
    {
        unit.setContentUnitID("differentID");
        
        assertEquals("differentID", unit.getContentUnitID());
        assertEquals("differentID", element.getAttribute("id"));
    }

    public void testSetIdentityData()
    {
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("differentName", "differentNameKey"));
        unit.setIdentityData(identity);
        
        assertEquals("differentName", unit.getIdentityData().getName().getValue());
        assertEquals("differentNameKey", unit.getIdentityData().getName().getTranslationKey());
        
        assertEquals("differentName", session.getChildren(session.getChildren(element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element [0])[0].getTextContent());
        assertEquals("differentNameKey", session.getChildren(session.getChildren(element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element [0])[0].getAttribute("translationKey"));
    }

    public void testSetResourceProperties()
    {
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop3ID", "prop3Ref");
        unit.setResourceProperties(Arrays.asList(prop1));
        
        assertEquals(1, unit.getResourceProperties().size());
        assertEquals("prop3ID", unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        assertEquals("prop3Ref", unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());

        assertEquals(1, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        assertEquals("prop3ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        assertEquals("prop3Ref", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetDerivedVariables()
    {
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar3ID", "dvar3Expression");
        unit.setDerivedVariables(Arrays.asList(dvar1));
        
        assertEquals(1, unit.getDerivedVariables().size());
        assertEquals("dvar3ID", unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        assertEquals("dvar3Expression", unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());

        assertEquals(3, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        assertEquals("dvar3ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        assertEquals("dvar3Expression", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetConditionalDerivedVariables()
    {
        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con5Name", "con5NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con1);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var3ID", Arrays.asList(exp1));
        unit.setConditionalDerivedVariables(Arrays.asList(var1));
        
        assertEquals(1, unit.getConditionalDerivedVariables().size());
        assertEquals("var3ID", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        assertEquals("exp3Expression", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        assertEquals("con5Name", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        assertEquals("con5NameKey", unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());

        assertEquals(3, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        assertEquals("var3ID", session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        assertEquals("exp3Expression", session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        assertEquals("con5Name", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        assertEquals("con5NameKey", session.getChildren(session.getChildren(session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetParameterGroups()
    {
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param5ID");
        ParameterGroup group1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group1.setBooleanParameters(Arrays.asList(param1));
        unit.setParameterGroups(Arrays.asList(group1));

        assertEquals(1, unit.getParameterGroups().size());
        assertEquals(1, unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        assertEquals("param5ID", unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());

        assertEquals(1, session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        assertEquals(1, session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        assertEquals("param5ID", session.getChildren(session.getChildren(session.getChildren(element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
    }
    
}
