/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Describable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;

/**
 * PropertyConstraintType provides the type definition of the Property elements of RequirementResourceConstraintType. It supports 
 * definition of a required value or set of acceptable values for a particular resource property.
 */
public interface PropertyConstraint extends Describable {
	/**
	 * Gets the property name.
	 * 
	 * The property name can be used to find the property value in the deployment environment. This name may be specified in profiles.
	 * 
	 * @return Name of the constrained property.
	 */
	String getPropertyName();
	
	/**
	 * Sets the property name.
	 * 
	 * The property name can be used to find the property value in the deployment environment. This name may be specified in profiles.
	 * 
	 * @param propertyName Name of the constrained property.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setPropertyName(String propertyName);
	
	/**
	 * Gets the value.
	 * 
	 * The result of evaluating this variable expression represents the required value of the named resource property. 
	 * 
	 * @return Required property value.
	 */
	String getValue();
	
	/**
	 * Sets the value.
	 * 
	 * The result of evaluating this variable expression represents the required value of the named resource property. 
	 * 
	 * @param value Required property value.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setValue(String value);
	
	/**
	 * Gets the list of required property values.
	 * 
	 * A list of required values can be defined in place of a single required value.
	 * 
	 * @return List of required property values.
	 */
	PropertyValueList getValueList();
	 
	/**
	 * Sets the list of required property values.
	 * 
	 * A list of required values can be defined in place of a single required value.
	 * 
	 * @param list List of required property values.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setValueList(PropertyValueList list);
}
