/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * The KeyValue element contains a single public key that may be useful in validating the 
 * signature. 
 * 
 * Structured formats for defining DSA (REQUIRED) and RSA (RECOMMENDED) public 
 * keys are defined in Signature Algorithms (section 6.4). The KeyValue element may include 
 * externally defined public keys values represented as PCDATA or element types from an 
 * external namespace.
 * 
 */
public interface KeyValue {
	/**
	 * Gets the DSAKeyValue.
	 * 
	 * DSA keys and the DSA signature algorithm are specified in [DSS]. DSA public key values 
	 * can have the following fields:
	 * P
	 *  a prime modulus meeting the [DSS] requirements
	 * Q
	 *  an integer in the range 2**159 < Q < 2**160 which is a prime divisor of P-1
	 * G
	 *  an integer with certain properties with respect to P and Q
	 * Y
	 *  G**X mod P (where X is part of the private key and not made public)
	 * J
	 *  (P - 1) / Q
	 * seed
 	 *  a DSA prime generation seed
 	 * pgenCounter
 	 *  a DSA prime generation counter 
 	 *  
	 * @return DSAKeyValue.
	 */
	DSAKeyValue getDSAKeyValue();
	
	/**
	 * Sets the DSAKeyValue.
	 * 
	 * DSA keys and the DSA signature algorithm are specified in [DSS]. DSA public key values 
	 * can have the following fields:
	 * P
	 *  a prime modulus meeting the [DSS] requirements
	 * Q
	 *  an integer in the range 2**159 < Q < 2**160 which is a prime divisor of P-1
	 * G
	 *  an integer with certain properties with respect to P and Q
	 * Y
	 *  G**X mod P (where X is part of the private key and not made public)
	 * J
	 *  (P - 1) / Q
	 * seed
 	 *  a DSA prime generation seed
 	 * pgenCounter
 	 *  a DSA prime generation counter 
 	 *  
	 * @param dsaKeyValue The new DSAKeyValue.
	 */
	void setDSAKeyValue(DSAKeyValue dsaKeyValue);
	
	/**
	 * Gets the RSAKeyValue.
	 * 
	 * RSA key values have two fields: Modulus and Exponent.
	 * 
	 * @return RSAKeyValue.
	 */
	RSAKeyValue getRSAKeyValue();
	
	/**
	 * Sets the RSAKeyValue.
	 * 
	 * RSA key values have two fields: Modulus and Exponent.
	 * 
	 * @param rsaKeyValue The new RSAKeyValue.
	 */
	void setRSAKeyValue(RSAKeyValue rsaKeyValue);
}
