/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
/**
 * 
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.rpm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.rpm.RPMReader;

/**
 * 
 *
 */
public class RPMReader_Test extends TestCase {

	/**
	 * @param name
	 */
	public RPMReader_Test(String name) {
		super(name);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public void testValidFileName() throws MalformedURLException, IOException{
		String filename = AllTests.VALID_RPM;
		RPMReader reader = new RPMReader(filename);
	}
	
	public void testInvalidFileName() throws MalformedURLException, IOException{
		String filename = AllTests.ARTIFACTSFILE_LOCATION + "FileNotHere.rpm";
		try {
			RPMReader reader = new RPMReader(filename);
			fail("Did not throw FileNotFoundException when invalid file name is given.");
		} catch (FileNotFoundException e) {
			// Expected
		}
	}
	
	public void testInvalidFile_NotRPM() throws MalformedURLException, IOException{
		String filename = AllTests.NOT_RPM;
		try {
			fail("Non RPM file not handled yet.");
			RPMReader reader = new RPMReader(filename);
			fail("Did not throw Exception when non RPM file is given.");
		} catch (Exception e) {
			// Expected
		}
	}
	
	public void testInvalidFile_NotVersion3RPM() throws MalformedURLException, IOException{
		fail("None version 3 RPM file not handled yet.");
	}
	
	public void testInvalidFile_NoExpectedSignature() throws MalformedURLException, IOException{
		fail("No Expected Signature not handled yet.");		
	}
}
