/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.rpm;

import java.io.IOException;
import java.io.RandomAccessFile;

public class RPMIndexEntry {
	private int tag;

	private int type;

	private long offset;

	private int count;

	private byte[] byteData;

	private int[] intData;

	private short[] shortData;

	private long[] longData;

	private String stringData;

	private String[] stringArrayData;

	private byte[] binData;

	private final static int type_null = 0;

	private final static int type_char = 1;

	private final static int type_int8 = 2;

	private final static int type_int16 = 3;

	private final static int type_int32 = 4;

	private final static int type_int64 = 5;

	private final static int type_string = 6;

	private final static int type_bin = 7;

	private final static int type_string_array = 8;
	
	private final static int type_i18nstring = 9;

	public byte[] getByteData() {
		return byteData;
	}

	public int[] getIntData() {
		return intData;
	}

	public short[] getShortData() {
		return shortData;
	}

	public long[] getLongData() {
		return longData;
	}

	public String getStringData() {
		return stringData;
	}

	public String[] getStringArrayData() {
		return stringArrayData;
	}

	public byte[] getBinData() {
		return binData;
	}

	public int getTag() {
		return tag;
	}

	public int getType() {
		return type;
	}

	public RPMIndexEntry(int tag, int type, long offset, int count) {
		this.tag = tag;
		this.type = type;
		this.offset = offset;
		this.count = count;
	}

	private String readString(RandomAccessFile file) throws IOException {
		StringBuffer strBuf = new StringBuffer();
		byte r[] = new byte[1];
		file.read(r);
		while (r[0] != 0) {
			strBuf.append(new String(r));
			file.read(r);
		}
		return new String(strBuf);
	}

	private String convertToHexString(byte array[]) {
		StringBuffer hexBuff = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			hexBuff.append(Integer.toHexString(array[i]));
		}

		return (new String(hexBuff));
	}

	public void parseData(RandomAccessFile file) throws IOException {
		file.seek(offset);

		if (type == type_null) {
			return;
		} else if ((type == type_char) || (type == type_int8)) {
			byteData = new byte[count];
			for (int i = 0; i < count; i++) {
				byteData[i] = file.readByte();
			}
			stringData = String.valueOf(byteData);
		} else if (type == type_int16) {
			shortData = new short[count];
			for (int i = 0; i < count; i++) {
				shortData[i] = file.readShort();
			}
			stringData = String.valueOf(shortData);
		} else if (type == type_int32) {
			intData = new int[count];
			for (int i = 0; i < count; i++) {
				intData[i] = file.readInt();
			}
			stringData = String.valueOf(intData);
		} else if (type == type_int64) {
			longData = new long[count];
			for (int i = 0; i < count; i++) {
				longData[i] = file.readLong();
			}
			stringData = String.valueOf(longData);
		} else if (type == type_string || type == type_i18nstring) {
			stringData = readString(file);
		} else if (type == type_string_array) {
			stringData = null; // set single Data String to null
			stringArrayData = new String[count];
			for (int i = 0; i < count; i++) {
				stringArrayData[i] = readString(file);
			}
		} else if (type == type_bin) {
			binData = new byte[count];
			file.read(binData);
			stringData = convertToHexString(binData);
		}
	}
}
