/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter.widget;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.MapParameterImpl;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IIDResolver;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetProperties
extends AbstractOutputter {
    public static final String TAG = "tag";
    public static final String FUNCTION = "func";
    protected String rootDir = "";

    @Override
    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        this.rootDir = context.getRealPath("views");
        super.initalize(context, parameters);
    }

    @Override
    public void render(PrintWriter writer, IParameters input) throws Exception {
        if (input.getParameter(FUNCTION) != null) {
            if (input.getParameter(FUNCTION).equals("getTags")) {
                this.generateFileMap(writer);
            }
        } else {
            String tag = input.getParameter(TAG);
            String bundleName = this.context.getInitParameter("WIDGET_BUNDLE_NAME");
            ResourceBundle[] RESOURCE_BUNDLES = null;
            if (bundleName != null) {
                String[] bundles = bundleName.split(",");
                RESOURCE_BUNDLES = new ResourceBundle[bundles.length];
                int x = 0;
                while (x < bundles.length) {
                    RESOURCE_BUNDLES[x] = ResourceBundle.getBundle(bundles[x]);
                    ++x;
                }
            } else {
                RESOURCE_BUNDLES = new ResourceBundle[]{};
            }
            if (tag != null) {
                writer.write("{view:");
                this.readPropertyFile(tag, "view.jprop", writer, RESOURCE_BUNDLES);
                writer.write(",");
                writer.write("dataMap:");
                this.readPropertyFile(tag, "datamap.jprop", writer, RESOURCE_BUNDLES);
                writer.write("}");
            } else {
                writer.write("{}");
            }
        }
    }

    protected void generateFileMap(PrintWriter pw) {
        ArrayList<Object[]> dirList = new ArrayList<Object[]>();
        this.visitAllFiles(new File(this.rootDir), dirList, new Stack<String>());
        pw.print("[");
        int x = 0;
        while (x < dirList.size()) {
            Object[] dirTags;
            if (x > 0) {
                pw.print(",");
            }
            if ((dirTags = (Object[])dirList.get(x)).length > 1) {
                pw.print("\"");
                int y = 1;
                while (y < dirTags.length) {
                    pw.print(dirTags[y]);
                    if (y < dirTags.length - 1) {
                        pw.print(" ");
                    }
                    ++y;
                }
                pw.print("\"");
            }
            ++x;
        }
        pw.print("]");
    }

    protected void visitAllFiles(File dir, List<Object[]> dirList, Stack<String> dirStack) {
        String parentFile;
        if (dir.isDirectory()) {
            dirStack.push(dir.getName());
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                this.visitAllFiles(new File(dir, children[i]), dirList, dirStack);
                ++i;
            }
            dirStack.pop();
        } else if (dir.getName().endsWith("view.jprop") && !dirList.contains(parentFile = dir.getParent())) {
            dirList.add(dirStack.toArray());
        }
    }

    protected String generateFilename(String tag, String filename) {
        String[] tags = tag.split(" ");
        String newFileName = String.valueOf(this.rootDir) + File.separator;
        int x = 0;
        while (x < tags.length) {
            newFileName = String.valueOf(newFileName) + tags[x] + File.separator;
            ++x;
        }
        return String.valueOf(newFileName) + filename;
    }

    protected void readPropertyFile(String tag, String filename, Writer writer, ResourceBundle[] RESOURCE_BUNDLE) throws Exception {
        block17: {
            this.generateFilename(tag, filename);
            FileInputStream fis = null;
            ByteArrayOutputStream bos = null;
            try {
                int c;
                String genFilename = this.generateFilename(tag, filename);
                File fileExists = new File(genFilename);
                if (!fileExists.exists() || !fileExists.isFile()) break block17;
                fis = new FileInputStream(this.generateFilename(tag, filename));
                bos = new ByteArrayOutputStream();
                boolean macroStart = false;
                boolean macroStart2 = false;
                StringBuffer macroBuffer = null;
                while ((c = fis.read()) != -1) {
                    if (macroStart) {
                        if ((char)c == '{') {
                            macroBuffer = new StringBuffer();
                            macroStart2 = true;
                        } else {
                            writer.write(36);
                            macroBuffer = null;
                        }
                        macroStart = false;
                    }
                    if ((char)c == '$') {
                        macroStart = true;
                    }
                    if (macroBuffer != null) {
                        if ((char)c == '}') {
                            String macroValue = "";
                            int x = 0;
                            while (x < RESOURCE_BUNDLE.length) {
                                try {
                                    macroValue = RESOURCE_BUNDLE[x].getString(macroBuffer.toString());
                                }
                                catch (MissingResourceException missingResourceException) {}
                                ++x;
                            }
                            if (macroValue == null) {
                                macroValue = "";
                            }
                            writer.write(macroValue);
                            macroBuffer = null;
                            continue;
                        }
                        if (!macroStart2) {
                            macroBuffer.append((char)c);
                            continue;
                        }
                        if (!macroStart2) continue;
                        macroStart2 = false;
                        continue;
                    }
                    if (macroStart) continue;
                    writer.write(c);
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
        }
    }

    @Override
    public void setIdResolver(IIDResolver idResolver) {
    }

    public static final void main(String[] argv) throws Exception {
        PrintWriter pw = new PrintWriter(System.out);
        WidgetProperties out = new WidgetProperties();
        out.rootDir = "D:\\development\\wtp30\\eclipse\\workspace\\org.eclipse.cosmos.examples.e2e.dr.views\\WebContent\\views";
        out.generateFileMap(pw);
        HashMap<String, String> input = new HashMap<String, String>();
        input.put(TAG, "nav");
        out.render(pw, new MapParameterImpl(input));
        pw.flush();
        pw.close();
    }
}

