/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.common.provisional.exceptions;

/**
 * Constants for defining a situation.  Values are specified in WSDM MUWS Part 2 v1.1.   
 * 
 */
public interface SituationConstants {
	
	public static final String AVAILABILITY_SITUATION = "AvailabilitySituation";
	public static final String CAPABILITY_SITUATION = "CapabilitySituation";
	public static final String CONFIGURE_SITUATION = "ConfigureSituation";
	public static final String CONNECT_SITUATION = "ConnectSituation";
	public static final String CREATE_SITUATION = "CreateSituation";
	public static final String DEPENDENCY_SITUATION = "DependencySituation";
	public static final String DESTROY_SITUATION = "DestroySituation";
	public static final String REQUEST_SITUATION = "RequestSituation";
	public static final String REPORT_SITUATION = "ReportSituation";
	public static final String PERFORMANCE_REPORT_SITUATION = "PerformanceReportSituation";
	public static final String SECURITY_REPORT_SITUATION = "SecurityReportSituation";
	public static final String HEARTBEAT_REPORT_SITUATION = "HeartbeatReportSituation";
	public static final String STATUS_REPORT_SITUATION = "StatusReportSituation";
	public static final String TRACE_REPORT_SITUATION = "TraceReportSituation";
	public static final String DEBUG_REPORT_SITUATION = "DebugReportSituation";
	public static final String LOG_REPORT_SITUATION = "LogReportSituation";
	public static final String START_SITUATION = "StartSituation";
	public static final String START_INITIATED_SITUATION = "StartInitiatedSituation";
	public static final String RESTART_INITIATED_SITUATION = "RestartInitiatedSituation";
	public static final String START_COMPLETED_SITUATION = "StartCompletedSituation";
	public static final String STOP_SITUATION = "StopSituation";
	public static final String STOP_INITIATED_SITUATION = "StopInitiatedSituation";
	public static final String ABORT_INITIATED_SITUATION = "AbortInitiatedSituation";
	public static final String PAUSE_INITIATED_SITUATION = "PauseInitiatedSituation";
	public static final String STOP_COMPLETED_SITUATION = "StopCompletedSituation";
	public static final String OTHER_SITUATION = "OtherSituation";
	
	public static final short LOWEST_PRIORITY = 0;
	public static final short LOW_PRIORITY = 10;
	public static final short MEDIUM_PRIORITY = 50;
	public static final short HIGH_PRIORITY = 70;
	public static final short HIGHEST_PRIORITY = 100;

	public static final short UNKNOWN_SEVERITY = 0;
	public static final short INFO_SEVERITY = 1;
	public static final short WARNING_SEVERITY = 2;
	public static final short MINOR_SEVERITY = 3;
	public static final short MAJOR_SEVERITY = 4;
	public static final short CRITICAL_SEVERITY = 5;
	public static final short FATAL_SEVERITY = 6;


}
