/*******************************************************************************
 * Copyright (c) 2007, 2008 CA.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.List;

import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.provisional.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SaverHelper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.XMLUtil;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.eclipse.cosmos.provisional.dr.ps.common.IConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataViewOutputter extends AbstractOutputter {
	public static final String NAMESPACE_QUERY = "http://cmdbf.org/schema/1-0-0/query"; //$NON-NLS-1$
	public static final String CMDBF_QUERY="query"; //$NON-NLS-1$
	public static final String MDRNAME="mdrName"; //$NON-NLS-1$
	public static final String QUERY_ID="uuid"; //$NON-NLS-1$
	public static final String USERNAME="username"; //$NON-NLS-1$
	public static final String PASSWORD="password"; //$NON-NLS-1$
	public static final String SOAPVERSION="soapversion"; //$NON-NLS-1$
	
	protected String rootDir;
	protected int limit = 0;
	
	public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
		this.rootDir = context.getRealPath(IConstants.QUERYREPO);		
		String limitStr = context.getInitParameter("RESPONSE_HISTORY_LIMIT"); //$NON-NLS-1$
		if (limitStr != null){
			try {
				this.limit = Integer.parseInt(limitStr);
			} catch (RuntimeException e) {
				this.limit = 0;
			}		
		}
		super.initalize(context, parameters);
	}
	
	public void render(PrintWriter output, IParameters input) throws Exception {
		String query = input.getParameter(CMDBF_QUERY);
		String mdrEPR = null;
		String uuid = input.getParameter(QUERY_ID);
		String username = input.getParameter(USERNAME);
		String password = input.getParameter(PASSWORD);
		String soapversion = input.getParameter(SOAPVERSION);
		String mdrName = input.getParameter(MDRNAME);

		mdrEPR = getEPR(mdrName);
		if ((mdrName != null) && (query != null)){
			//get cdmbf query
			Element response = submitQuery(mdrEPR, query, username, password, soapversion);
			String responseStr =XMLUtil.xmlToString(response);
			SaverHelper.saveResponse(responseStr, uuid, rootDir, limit);
			output.print(responseStr);
				
		}
		

	}
	protected Element submitQuery(String mdrEPR, String query, String username, String password, String soapversion) throws Exception{
		QueryServiceClient queryService =   new QueryServiceClient(mdrEPR);
		if (username != null)
			queryService.setUsername(username);
		if (password != null)
			queryService.setPassword(password);
		if (soapversion != null)
			queryService.setSoapVersion(Integer.parseInt(soapversion));
		Document doc = XMLUtil.createDocument(query);
		Element elem = doc.getDocumentElement();
	    return queryService.graphQuery(elem);
	}
	
	protected String getEPR(String mdrName) {
		String uri = context.getInitParameter( "BROKER_EPR" ); //$NON-NLS-1$
		BrokerClient brokerclient = new BrokerClient(uri);
		List<DataManager> dataManagers = null;
		
		try {
			dataManagers = brokerclient.getDataManagerByNamespace(NAMESPACE_QUERY);
		} catch (Exception e) {
			return null;
		}
		
		for (int i = 0, dataManagerCount = dataManagers.size(); i < dataManagerCount; i++)
			{
				DataManager dataManager = dataManagers.get(i);
				String name = dataManager.getName();
				String epr = dataManager.getServiceEPR(NAMESPACE_QUERY);
				if (name.equals(mdrName))
					return epr;
			}
		return null;
	}	
}
