/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.cmdbf.query;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ResourceBundle;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;

public abstract class AbstractQueryService {
    protected CMDBfQueryOperation queryOp = new CMDBfQueryOperation(this.getQueryHandlerFactory(), null);
    protected Logger logger = null;

    protected abstract IQueryHandlerFactory getQueryHandlerFactory();

    public void init(ServiceContext serviceContext) {
        this.logger = Logger.getLogger(this.getClass());
        this.logger.setResourceBundle(ResourceBundle.getBundle("org.eclipse.cosmos.dc.provisional.cmdbf.messages"));
    }

    protected CMDBfQueryOperation getQueryOperation() {
        return this.queryOp;
    }

    public OMElement GraphQuery(OMElement query) throws CMDBfServiceException {
        OMElement documentElement = null;
        IQueryResult result = null;
        result = this.queryOp.execute((Reader)new StringReader(query.toString()));
        InputStream output = QueryOutputTransformer.transform((IQueryResult)result);
        XMLStreamReader parser = null;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(output);
        }
        catch (XMLStreamException e) {
            this.logger.l7dlog((Priority)Level.ERROR, "XMLStreamReader_ERROR", (Throwable)e);
            throw new CMDBfServiceException(1, 5, e.getMessage(), null, (Throwable)e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        documentElement = builder.getDocumentElement();
        return documentElement;
    }
}

