/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.smlif.export.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.cosmos.rm.internal.repository.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.internal.repository.core.FileSystemSMLRepository;
import org.eclipse.cosmos.rm.internal.repository.core.MetadataFileHandler;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLMessages;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLPage;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLRepositoryManager;
import org.eclipse.cosmos.rm.internal.smlif.export.ui.ExportToSMLIFWizard;
import org.eclipse.cosmos.rm.internal.smlif.export.ui.ExportToSMLIFWizardPage;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLMetadata;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToSMLIFWizardPage2
extends WizardPage {
    protected IStructuredSelection selection;
    protected ListViewer modelFileListViewer;
    protected ListViewer aliasListViewer;
    protected Combo typeCombo;
    protected Composite documentDetailComposite;
    protected Text nameText;
    protected Text baseURIText;
    protected Text displayNameText;
    protected Text versionText;
    protected Text descriptionText;
    protected boolean uninitializedIdentityFields = true;
    private Map<String, String[]> aliases;

    public ExportToSMLIFWizardPage2(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
        this.setSelection(selection);
        this.aliases = new Hashtable<String, String[]>();
    }

    protected void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    protected void updateDocumentList() {
        this.modelFileListViewer.setInput((Object)this.getModel());
        this.resetDocumentDetailComposite();
    }

    public void createControl(Composite parent) {
        Composite topComponent = new Composite(parent, 0);
        GridData topComponentData = new GridData(768);
        topComponent.setLayoutData((Object)topComponentData);
        GridLayout topComponentLayout = new GridLayout();
        topComponentLayout.numColumns = 1;
        topComponentLayout.makeColumnsEqualWidth = false;
        topComponent.setLayout((Layout)topComponentLayout);
        this.createIdentityInformationGroup(topComponent);
        this.createDocumentInformationGroup(topComponent);
        this.setControl((Control)topComponent);
        this.setPageComplete(true);
        Dialog.applyDialogFont((Control)topComponent);
    }

    protected void createIdentityInformationGroup(Composite topComponent) {
        Group identityInformationGroup = new Group(topComponent, 0);
        identityInformationGroup.setText(SMLMessages.exportWizardIdentityInformationGroupTitle);
        GridData identityInformationGroupData = new GridData(1808);
        identityInformationGroupData.horizontalSpan = 1;
        identityInformationGroup.setLayoutData((Object)identityInformationGroupData);
        GridLayout documentInformationGroupLayout = new GridLayout();
        documentInformationGroupLayout.numColumns = 2;
        documentInformationGroupLayout.makeColumnsEqualWidth = true;
        identityInformationGroup.setLayout((Layout)documentInformationGroupLayout);
        this.createNameAndURIComposite(identityInformationGroup);
        this.createDescriptionComposite(identityInformationGroup);
    }

    protected void createDescriptionComposite(Group identityInformationGroup) {
        Composite descriptionComposite = new Composite((Composite)identityInformationGroup, 0);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        descriptionComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        descriptionComposite.setLayout((Layout)layout);
        this.createFormLabel(descriptionComposite, SMLMessages.exportWizardDescriptionLabel);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.descriptionText = new Text(descriptionComposite, 2626);
        this.descriptionText.setLayoutData((Object)gd);
    }

    protected void createNameAndURIComposite(Group identityInformationGroup) {
        Composite nameAndURIComposite = new Composite((Composite)identityInformationGroup, 0);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        nameAndURIComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        nameAndURIComposite.setLayout((Layout)layout);
        this.createFormLabel(nameAndURIComposite, SMLMessages.exportWizardNameLabel);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.nameText = new Text(nameAndURIComposite, 2052);
        this.nameText.setLayoutData((Object)gd);
        this.createFormLabel(nameAndURIComposite, SMLMessages.exportWizardVersionLabel);
        this.versionText = new Text(nameAndURIComposite, 2052);
        this.versionText.setLayoutData((Object)gd);
        this.createFormLabel(nameAndURIComposite, SMLMessages.exportWizardDisplayNameLabel);
        this.displayNameText = new Text(nameAndURIComposite, 2052);
        this.displayNameText.setLayoutData((Object)gd);
        this.createFormLabel(nameAndURIComposite, SMLMessages.exportWizardBaseURILabel);
        this.baseURIText = new Text(nameAndURIComposite, 2052);
        this.baseURIText.setLayoutData((Object)gd);
        SMLCommonUtil.addURIValidator(this.baseURIText, new SMLPage(this));
    }

    protected void initDocumentIdentityFields() {
        String projectName = ((ExportToSMLIFWizard)this.getWizard()).getMainPage().getProjectName();
        FileSystemSMLRepository repository = projectName != null ? (FileSystemSMLRepository)SMLRepositoryManager.getRepository(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString()) : (FileSystemSMLRepository)SMLRepositoryManager.getRepository();
        MetadataFileHandler metadataHandler = repository.getMetadataProcessor().getMetadataHandler();
        if (this.nameText.getText().equals("")) {
            String nameFromMetadata = metadataHandler.getIdentity().getName();
            this.nameText.setText(nameFromMetadata == null ? "" : nameFromMetadata);
        }
        if (this.baseURIText.getText().equals("")) {
            String baseURI = metadataHandler.getIdentity().getBaseURI();
            this.baseURIText.setText(baseURI == null ? "" : baseURI);
        }
        if (this.displayNameText.getText().equals("")) {
            String displayName = metadataHandler.getIdentity().getDisplayName();
            this.displayNameText.setText(displayName == null ? "" : displayName);
        }
        if (this.versionText.getText().equals("")) {
            String version = metadataHandler.getIdentity().getVersion();
            this.versionText.setText(version == null ? "" : version);
        }
        if (this.descriptionText.getText().equals("")) {
            String descriptionFromMetadata = metadataHandler.getIdentity().getDescription();
            this.descriptionText.setText(descriptionFromMetadata == null ? "" : descriptionFromMetadata);
        }
        Object[] documents = this.getModel();
        int i = 0;
        while (i < documents.length) {
            ISMLMetadata metadata = ((ISMLDocument)documents[i]).getMetadata();
            String[] documentAliases = metadata.getAliases();
            if (documentAliases != null && documentAliases.length > 0) {
                this.aliases.put(metadata.getId(), metadata.getAliases());
            }
            ++i;
        }
    }

    protected void createDetectedDocumentsLabel(Composite topComponent) {
        Label detectedDocumentsLabel = new Label(topComponent, 0);
        detectedDocumentsLabel.setText(SMLMessages.exportWizardDetectedDocumentsLabel);
        GridData detectedDocumentsLabelData = new GridData(768);
        detectedDocumentsLabelData.grabExcessHorizontalSpace = true;
        detectedDocumentsLabelData.horizontalSpan = 2;
        detectedDocumentsLabel.setLayoutData((Object)detectedDocumentsLabelData);
    }

    protected void createDocumentInformationGroup(Composite topComponent) {
        Group documentInformationGroup = new Group(topComponent, 0);
        documentInformationGroup.setText(SMLMessages.exportWizardDocumentInformationGroupLabel);
        GridData documentInformationGroupData = new GridData(1808);
        documentInformationGroupData.horizontalSpan = 1;
        documentInformationGroup.setLayoutData((Object)documentInformationGroupData);
        GridLayout documentInformationGroupLayout = new GridLayout();
        documentInformationGroupLayout.numColumns = 2;
        documentInformationGroupLayout.makeColumnsEqualWidth = true;
        documentInformationGroup.setLayout((Layout)documentInformationGroupLayout);
        this.createDetectedDocumentsLabel((Composite)documentInformationGroup);
        this.createDocumentList(documentInformationGroup);
        this.createDocumentDetailComposite(documentInformationGroup);
    }

    protected void createDocumentDetailComposite(Group documentInformationGroup) {
        this.documentDetailComposite = new Composite((Composite)documentInformationGroup, 0);
        GridData gd = new GridData(1808);
        this.documentDetailComposite.setLayoutData((Object)gd);
        this.documentDetailComposite.setEnabled(false);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.documentDetailComposite.setLayout((Layout)layout);
        this.createTypeControls(this.documentDetailComposite);
        this.createAliasControls(this.documentDetailComposite);
    }

    protected void createAliasControls(Composite parent) {
        this.createFormLabel(parent, SMLMessages.exportWizardAliasesLabel);
        this.aliasListViewer = this.createStringListViewer(parent);
        this.createAliasAddRemoveButtons(parent);
    }

    protected void createFormLabel(Composite parent, String labelText) {
        Label aliasLabel = new Label(parent, 131072);
        aliasLabel.setText(labelText);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        aliasLabel.setLayoutData((Object)gd);
    }

    protected ListViewer createStringListViewer(Composite parent) {
        ListViewer listViewer = new ListViewer(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        listViewer.getControl().setLayoutData((Object)gd);
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return listViewer;
    }

    protected void createAliasAddRemoveButtons(Composite parent) {
        Composite buttonComposite = ExportToSMLIFWizard.createVerticalButtonPanel(parent);
        Button addButton = ExportToSMLIFWizard.createVerticalButtonPanelButton(buttonComposite, SMLMessages.exportWizardAddButtonLabel);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        if ("".equals(newText.trim())) {
                            return null;
                        }
                        boolean valid = false;
                        try {
                            valid = new URI(newText).getPath().equals(newText);
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                        if (valid) {
                            return null;
                        }
                        return NLS.bind((String)SMLMessages.exportWizardErrorURINotValid, (Object)newText);
                    }
                };
                InputDialog input = new InputDialog(ExportToSMLIFWizardPage2.this.getShell(), SMLMessages.exportWizardNewAliasTitle, SMLMessages.exportWizardNewAliasPrompt, "", validator);
                if (input.open() == 0) {
                    String[] documentAliases = (String[])ExportToSMLIFWizardPage2.this.aliases.get(ExportToSMLIFWizardPage2.this.getSelectedModelUnitFile().getMetadata().getId());
                    if (documentAliases == null) {
                        ExportToSMLIFWizardPage2.this.aliases.put(ExportToSMLIFWizardPage2.this.getSelectedModelUnitFile().getMetadata().getId(), new String[]{input.getValue().trim()});
                    } else {
                        String newAliasEntry = input.getValue().trim();
                        int i = 0;
                        while (i < documentAliases.length) {
                            if (documentAliases[i].equals(newAliasEntry)) {
                                return;
                            }
                            ++i;
                        }
                        String[] newAliases = new String[documentAliases.length + 1];
                        System.arraycopy(documentAliases, 0, newAliases, 0, documentAliases.length);
                        newAliases[documentAliases.length] = input.getValue().trim();
                        ExportToSMLIFWizardPage2.this.aliases.put(ExportToSMLIFWizardPage2.this.getSelectedModelUnitFile().getMetadata().getId(), newAliases);
                    }
                    ExportToSMLIFWizardPage2.this.aliasListViewer.refresh();
                    ExportToSMLIFWizardPage2.this.modelFileListViewer.setSelection(ExportToSMLIFWizardPage2.this.modelFileListViewer.getSelection());
                    ExportToSMLIFWizardPage2.this.getExportWizard().page3.updateComboChoices();
                }
            }
        });
        Button removeButton = ExportToSMLIFWizard.createVerticalButtonPanelButton(buttonComposite, SMLMessages.exportWizardRemoveButtonText);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String[] documentAliases = (String[])ExportToSMLIFWizardPage2.this.aliases.get(ExportToSMLIFWizardPage2.this.getSelectedModelUnitFile().getMetadata().getId());
                String[] selectedAliases = ExportToSMLIFWizardPage2.this.aliasListViewer.getList().getSelection();
                ArrayList<String> updatedList = new ArrayList<String>();
                int i = 0;
                while (i < documentAliases.length) {
                    boolean foundEntry = false;
                    int j = 0;
                    while (j < selectedAliases.length) {
                        if (documentAliases[i].equals(selectedAliases[j])) {
                            foundEntry = true;
                            break;
                        }
                        ++j;
                    }
                    if (!foundEntry) {
                        updatedList.add(documentAliases[i]);
                    }
                    ++i;
                }
                ExportToSMLIFWizardPage2.this.aliases.put(ExportToSMLIFWizardPage2.this.getSelectedModelUnitFile().getMetadata().getId(), updatedList.toArray(new String[updatedList.size()]));
                ExportToSMLIFWizardPage2.this.aliasListViewer.refresh();
                ExportToSMLIFWizardPage2.this.modelFileListViewer.setSelection(ExportToSMLIFWizardPage2.this.modelFileListViewer.getSelection());
                ExportToSMLIFWizardPage2.this.getExportWizard().page3.updateComboChoices();
            }
        });
    }

    protected Composite createVerticalButtonPanel(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonCompositeData = new GridData();
        buttonCompositeData.verticalAlignment = 4;
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        return buttonComposite;
    }

    protected void createTypeControls(Composite parent) {
        Label typeLabel = new Label(parent, 131072);
        typeLabel.setText(SMLMessages.exportWizardTypeLabel);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        typeLabel.setLayoutData((Object)gd);
        this.typeCombo = new Combo(parent, 8);
        this.typeCombo.add(SMLMessages.exportWizardTypeComboDefinition);
        this.typeCombo.add(SMLMessages.exportWizardTypeComboInstance);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ExportToSMLIFWizardPage2.this.typeCombo.getText().equals(SMLMessages.exportWizardTypeComboDefinition)) {
                    ((SMLFileMetadata)ExportToSMLIFWizardPage2.this.getSelectedModelUnitFile().getMetadata()).setDocumentType(0);
                }
                if (ExportToSMLIFWizardPage2.this.typeCombo.getText().equals(SMLMessages.exportWizardTypeComboInstance)) {
                    ((SMLFileMetadata)ExportToSMLIFWizardPage2.this.getSelectedModelUnitFile().getMetadata()).setDocumentType(1);
                }
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.typeCombo.setLayoutData((Object)gd);
        Label spacer = new Label(parent, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        spacer.setLayoutData((Object)gd);
    }

    protected void createDocumentList(Group documentInformationGroup) {
        this.modelFileListViewer = new ListViewer((Composite)documentInformationGroup, 2820);
        this.modelFileListViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                super.inputChanged(viewer, oldInput, newInput);
            }
        });
        this.modelFileListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return SMLRepositoryUtil.getDocumentName((ISMLDocument)((ISMLDocument)element));
            }
        });
        this.modelFileListViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object resource1, Object resource2) {
                return ((ISMLDocument)resource1).getMetadata().getId().compareTo(((ISMLDocument)resource2).getMetadata().getId());
            }
        });
        this.modelFileListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    ExportToSMLIFWizardPage2.this.resetDocumentDetailComposite();
                } else {
                    ExportToSMLIFWizardPage2.this.documentDetailComposite.setEnabled(true);
                    ISMLDocument selectedModelUnitFile = (ISMLDocument)((IStructuredSelection)event.getSelection()).getFirstElement();
                    ExportToSMLIFWizardPage2.this.aliasListViewer.setInput(ExportToSMLIFWizardPage2.this.aliases.get(selectedModelUnitFile.getMetadata().getId()));
                    ExportToSMLIFWizardPage2.this.typeCombo.select(selectedModelUnitFile.getMetadata().getDocumentType() == 0 ? ExportToSMLIFWizardPage2.this.typeCombo.indexOf(SMLMessages.exportWizardTypeComboDefinition) : ExportToSMLIFWizardPage2.this.typeCombo.indexOf(SMLMessages.exportWizardTypeComboInstance));
                }
            }
        });
        GridData listViewerData = new GridData(4, 4, true, true);
        this.modelFileListViewer.getControl().setLayoutData((Object)listViewerData);
    }

    protected void resetDocumentDetailComposite() {
        this.documentDetailComposite.setEnabled(false);
        this.aliasListViewer.setInput((Object)new Object[0]);
        this.typeCombo.deselectAll();
    }

    public String getSMLIFName() {
        return this.nameText.getText();
    }

    public String getBaseURI() {
        return this.baseURIText.getText();
    }

    public String getVersion() {
        return this.versionText.getText();
    }

    public String getDisplayName() {
        return this.displayNameText.getText();
    }

    public String getSMLIFDescription() {
        return this.descriptionText.getText();
    }

    protected ISMLDocument getSelectedModelUnitFile() {
        return (ISMLDocument)((IStructuredSelection)this.modelFileListViewer.getSelection()).getFirstElement();
    }

    protected ExportToSMLIFWizard getExportWizard() {
        return (ExportToSMLIFWizard)this.getWizard();
    }

    protected ExportToSMLIFWizardPage getMainPage() {
        return (ExportToSMLIFWizardPage)this.getWizard().getStartingPage();
    }

    protected Object[] getModel() {
        Collection<ISMLDocument> selectedFiles = this.getExportWizard().getSelectedFiles().values();
        return selectedFiles.size() == 0 ? new ISMLDocument[]{} : selectedFiles.toArray();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.initFromMetadata();
        if (visible) {
            this.modelFileListViewer.setInput((Object)this.getModel());
        }
    }

    protected void initFromMetadata() {
        if (this.uninitializedIdentityFields) {
            this.initDocumentIdentityFields();
            this.getExportWizard().page3.ruleBindingsTableViewer.refresh();
            this.uninitializedIdentityFields = false;
        }
    }

    public Map<String, String[]> getAliases() {
        return this.aliases;
    }
}

