/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.net.URI;
import org.eclipse.cosmos.rm.internal.validation.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityDataBuilder
extends AbstractDataBuilder<SMLIFIdentity> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.IdentityDataBuilder";
    private SMLIFIdentity smlIfIdentity = new SMLIFIdentity();
    private boolean identityElementHit;
    private boolean nameElementHit;
    private boolean descriptionElementHit;
    private boolean baseURIHit;
    private String name = "";
    private String description = "";
    private String baseURI = "";

    public IdentityDataBuilder() {
        super.addEvent(1);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.elementNotification(uri, localName, attributes, true, this.getCurrentBaseURI());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.nameElementHit) {
            this.name = String.valueOf(this.name) + new String(ch, start, length);
        } else if (this.descriptionElementHit) {
            this.description = String.valueOf(this.description) + new String(ch, start, length);
        } else if (this.baseURIHit) {
            this.baseURI = String.valueOf(this.baseURI) + new String(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        URI saveCurrentBaseURI = this.getCurrentBaseURI();
        super.endElement(uri, localName, qName);
        this.elementNotification(uri, localName, null, false, saveCurrentBaseURI);
    }

    private void validateBaseURI(URI currentBaseURI) {
        int lineNum = this.getLocator() == null ? -1 : this.getLocator().getLineNumber();
        this.baseURI = this.baseURI.trim();
        if (URIReference.validModelBaseURI(this.baseURI, currentBaseURI, this.getMessageOutputter(), lineNum)) {
            this.smlIfIdentity.setBaseURI(this.baseURI);
        }
        this.baseURI = "";
    }

    private void elementNotification(String uri, String localName, Attributes attributes, boolean start, URI currentBaseURI) {
        if (!"http://www.w3.org/2008/09/sml-if".equals(uri)) {
            return;
        }
        if ("identity".equals(localName)) {
            this.identityElementHit = start;
            if (!start && !"".equals(this.baseURI)) {
                this.validateBaseURI(currentBaseURI);
            }
        } else if (this.identityElementHit) {
            if ("name".equals(localName)) {
                this.nameElementHit = start;
                if (!start) {
                    this.smlIfIdentity.setName(this.name);
                }
            } else if ("description".equals(localName)) {
                this.descriptionElementHit = start;
                if (!start) {
                    this.smlIfIdentity.setDescription(this.description);
                }
            } else if ("baseURI".equals(localName)) {
                this.baseURIHit = start;
            }
        }
    }

    @Override
    public SMLIFIdentity getDataStructure() {
        return this.smlIfIdentity;
    }

    public static String retrieveBaseURI() {
        SMLIFIdentity smlIdentity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure(0, ID);
        return smlIdentity == null ? null : smlIdentity.getBaseURI();
    }
}

