/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts;

import java.util.ArrayList;
import java.util.List;


/**
 * Abstract parent class of graph collections that can contain
 * items and/or relationships.
 * 
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractGraphCollection implements IGraphElementCollection
{
	private String id;
	private List<IGraphElement> elements; // 1 or more
	private boolean startingContext;
	
	public AbstractGraphCollection(String templateId)
	{
		this.id = templateId;
		this.elements = new ArrayList<IGraphElement>();
	}
	
	protected List<IGraphElement> getCollection() 
	{
		return elements;
	}
	
	public IGraphElement[] getElements()
	{
		return elements.toArray(new IGraphElement[elements.size()]);
	}
	
	public int hashCode() 
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ((elements == null) ? 0 : elements.hashCode());
		result = prime * result
				+ ((id == null) ? 0 : id.hashCode());
		return result;
	}

	public boolean equals(Object obj) 
	{
		return 
			this == obj ? true : 
			(obj == null || this.getClass() != obj.getClass() ? 
					false : checkEquality(obj));

	}

	private boolean checkEquality(Object obj)
	{
		final AbstractGraphCollection other = (AbstractGraphCollection) obj;		
		
		if ((elements == null && other.getCollection() != null) ||
			(!elements.equals(other.getCollection())) ||
			(id == null && other.getId() != null) ||
			(!id.equals(other.getId()))
			)
		{
			return false;
		}
		return true;
	}

	public void clear()
	{
		getCollection().clear();
	}

	public boolean isEmpty()
	{
		return isStartingContext() ? false : getCollection().isEmpty();
	}
	
	public void setElements(IGraphElement[] elements)
	{		
		this.elements = new ArrayList<IGraphElement>();
		for (int i = 0; i < elements.length; i++)
		{
			this.elements.add(elements[i]);
		}
	}

	public String getId()
	{		
		return id;
	}

	public int getSize()
	{
		return elements.size();
	}
	
	public boolean isStartingContext()
	{
		return startingContext;
	}

	public void setStartingContext(boolean startingContext)
	{
		this.startingContext = startingContext;
	}
	
	public void addElement(IGraphElement element)
	{
		if (elements != null)
		{
			elements.add(element);
		}
	}
	
	public void removeElement(IGraphElement element)
	{
		if (elements == null)
		{
			return;
		}
		elements.remove(element);
	}

	protected void setElements(List<IGraphElement> elements) {
		this.elements = elements;
	}
}
